

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container">
	<?php if($observado==1): ?>
		<?php if($estado==1): ?>
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-danger" role="alert">
					<strong>Alerta!!</strong> Su expediente ha sido observado, deberá adjutar los archivos observados indicados en la parte inferior derecha.
				</div>
			</div>
		</div>
		<?php endif; ?>
	<?php endif; ?>
	<?php if($expediente->estado==0): ?>
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-info" role="alert">
					<strong>Aviso</strong> Su expediente sera revisado previamente en Mesa de Partes, para verificar su documentos.
				</div>
			</div>
		</div>
	<?php endif; ?>
	<?php if($expediente->estado==2): ?>
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-danger" role="alert">
					<strong>Aviso</strong> Su expediente ha sido rechazado, realizar una nueva solicitud.
				</div>
			</div>
		</div>
	<?php endif; ?>
	<div class="row">
		<div class="col-md-7">
			<div class="card">
				<div class="card-header">
					<h6 class="card-title my-0">Revisión de Expediente</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Estado</label>
							<?php if($expediente->estado==2): ?>
							<p class="font-weight-bold text-danger" style="font-size:20px"><?php echo e($expediente->Estado); ?></p>
							<?php elseif($expediente->estado==3): ?>
							<p class="font-weight-bold text-primary" style="font-size:20px"><?php echo e($expediente->Estado); ?></p>
							<?php else: ?>
							<p class="font-weight-bold" style="font-size:20px"><?php echo e($expediente->Estado); ?></p>
							<?php endif; ?>
						</div>
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Ultima Observación</label>
							<p class="font-weight-bold text-dark" style="font-size:20px"><i class="fas fa-info-circle"></i> <?php echo e($expediente->Observacion); ?></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<table class="table table-striped">
								<thead class="thead-dark">
									<tr>
										<th>#</th>
										<th>Oficina</th>
										<th>Acción</th>
										<th>Observación</th>
										<th>Oficina Destino</th>
									</tr>
								</thead>
								<tbody id="seguimiento" style="font-size:12px">
								</tbody>
							</table>
          				</div>
					</div>
				</div>
			</div>
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos del Expediente</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Código de Solicitud</label>
							<p><?php echo e($expediente->SolicitudCodigo); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Código de Expediente</label>
							<p><?php echo e($expediente->CodigoExpediente); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Número Documento</label>
							<p><?php echo e($expediente->NumeroDocumento); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Folios</label>
							<p><?php echo e($expediente->Folio); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Fecha de Registro</label>
							<p><?php echo e($expediente->FechaReg); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Estado</label>
							<p><?php echo e($expediente->Estado); ?></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Asunto</label>
							<p><?php echo e($expediente->TipoExpediente); ?> | <?php echo e($expediente->Asunto); ?></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Observación</label>
							<p><?php echo e($expediente->Observacion); ?></p>
						</div>
					</div>
				</div>
			</div>
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos del Solicitante</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Tipo Persona</label>
							<?php if($expediente->TipoEntidad==1): ?>
							<p>Persona Jurídica</p>
							<?php else: ?>
							<p>Persona Natural</p>
							<?php endif; ?>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0"><?php echo e($expediente->TipoDocumento); ?> | Apellidos y Nombres</label>
							<p><?php echo e($expediente->Responsable); ?></p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Teléfono</label>
							<p><?php echo e($expediente->Telefono); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Email</label>
							<p><?php echo e($expediente->Email); ?></p>
						</div>
					</div>
					<div class="row">
						<?php if($expediente->Extranjero==0): ?>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
							<p><?php echo e($departamento->nombre); ?> | <?php echo e($provincia->nombre); ?> | <?php echo e($distrito->nombre); ?></p>
						</div>
						<?php else: ?>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Pais</label>
							<p><?php echo e($expediente->Pais); ?></p>
						</div>
						<?php endif; ?>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Dirección</label>
							<p><?php echo e($expediente->Direccion); ?></p>
						</div>
					</div>
				</div>
			</div>
			<?php if($expediente->TipoEntidad==1): ?>
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos de Empresa</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
							<p><?php echo e($expediente->Ruc); ?> | <?php echo e($expediente->RazonSocial); ?></p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Dirección</label>
							<p><?php echo e($expediente->DireccionEmpresa); ?></p>
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>
			
		</div>
		<div class="col-md-5">
			<div class="card">
				<div class="card-header">
					<h6 class="card-title my-0">Archivos Adjuntos</h6>
				</div>
				<div class="card-body pt-1">
					<div class="row">
						<?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<div class="col-md-12">
							<label class="font-weight-bold mb-0 text-dark"><?php echo e($value->nombre); ?> <span class="text-success"><?php echo e($value->observado==1?'(Observado)':''); ?></span></label>
							<br>
							
							<?php switch($value->tipo):
								case (1): ?>
										<?php if($value->estado==1): ?>
											<a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark mt-0" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
										<?php else: ?>
											<p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
										<?php endif; ?>
									<?php break; ?>
								<?php case (2): ?>
										<?php if($expediente->estado == 1): ?>
											<?php if($value->estado==1): ?>
												<a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark mt-0" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
											<?php else: ?>
												<form id="formulary<?php echo e($value->id); ?>">
													<div class='form-group mb-0'>
														<!-- <label class='font-weight-bold text-dark' for='archivoval.orden'>val.orden.- val.nombre</label> -->
														<input type='file' 
															required='true' data-msg-required='Este campo es requerido.'
															filesize='1' data-msg-filesize='El archivo pesa mas de 1M.'
															extension='pdf' data-msg-extension='Solo se permite archivos pdf.'
															id='archivoval.orden' name='archivo' class='d-block'>
													</div>
													<button class="btn btn-success btn-sm subir mb-0" id="<?php echo e($value->id); ?>">Subir</button>
												</form>
											<?php endif; ?>
										<?php else: ?>
										<p class='mx-3 text-info'><i class='fas fa-info-circle'></i> Éste Documento se adjuntará en el proceso del trámite.</p>
										<?php endif; ?>
									<?php break; ?>
								<?php case (3): ?>
										<p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Éste Documento se presentara físicamente.</p>
									<?php break; ?>
								<?php case (4): ?>
										<p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
									<?php break; ?>

								<?php default: ?>
										
							<?php endswitch; ?>
						</div>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-validation/dist/jquery.validate.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-validation/dist/additional-methods.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/validator.setDefaults.js')); ?>"></script>
<script>
  $.validator.addMethod('filesize', function (value, element, param) {
      return this.optional(element) || (element.files[0].size <= param * 1000000)
  }, 'File size must be less than {0}');
</script>
<script type="text/javascript">
  var rowidex = <?php echo $expediente->RowId; ?>;
</script>

<script type="text/javascript" src="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/web/seguimiento/expediente.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\tramite\resources\views/web/seguimiento/expediente.blade.php ENDPATH**/ ?>