

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col">
  <a href="<?php echo e(url('/extranet/mesa')); ?>" class="btn btn-dark float-right">Ver todos los Expedientes</a>
    
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Revisión de Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <!-- <div class="col">
            <button class="btn btn btn-light" id="seguimiento_modal"><i class="fas fa-eye"></i> Seguimiento</button>
          </div> -->
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Estado</label>
            <p><?php echo e($expediente->Estado); ?></p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Asunto</label>
            <h5 class="text-primary-extranet font-weight-bold"><?php echo e($expediente->TipoExpediente); ?> | <?php echo e($expediente->Asunto); ?></h5>
          </div>
        </div>
      <?php if($expediente->estado==0): ?>
        <button class="btn btn-danger" id="rechazar_modal"><i class="fas fa-times"></i> Rechazar</button>
        <button class="btn btn-success" id="derivar_modal"><i class="fas fa-check"></i> Derivar Expediente</button>
      <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Requisitos Adjuntos</h6>
      </div>
      <div class="card-body pt-1">
        <div class="row">
          <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark"><?php echo e($value->nombre); ?></label>
            <br>
            
            <?php switch($value->tipo):
              case (1): ?>
                  <?php if($value->estado==1): ?>
                    <a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  <?php else: ?>
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  <?php endif; ?>
                <?php break; ?>
              <?php case (2): ?>
                  <p class='mx-3 text-info'><i class='fas fa-info-circle'></i> Este Documento se adjuntara en el proceso del tramite.</p>
                <?php break; ?>
              <?php case (3): ?>
                  <p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Este Documento se presentara fisicamente.</p>
                <?php break; ?>
              <?php case (4): ?>
                  <p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
                <?php break; ?>
              <?php default: ?>
                  
            <?php endswitch; ?>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Solicitud</label>
            <p><?php echo e($expediente->SolicitudCodigo); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p><?php echo e($expediente->CodigoExpediente); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Número Documento</label>
            <p><?php echo e($expediente->NumeroDocumento); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Folios</label>
            <p><?php echo e($expediente->Folio); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p><?php echo e($expediente->FechaReg); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Estado</label>
            <p><?php echo e($expediente->Estado); ?></p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observación</label>
            <p><?php echo e($expediente->Observacion); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Solicitante</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col">
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Tipo Persona</label>
                <?php if($expediente->TipoEntidad==1): ?>
                <p>Persona Jurídica</p>
                <?php else: ?>
                <p>Persona Natural</p>
                <?php endif; ?>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0"><?php echo e($expediente->TipoDocumento); ?> | Apellidos y Nombres</label>
                <p><?php echo e($expediente->Responsable); ?></p>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Teléfono</label>
                <p><?php echo e($expediente->Telefono); ?></p>
              </div>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Email</label>
                <p><?php echo e($expediente->Email); ?></p>
              </div>
            </div>
            <div class="row">
              <?php if($expediente->Extranjero==0): ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
                <p><?php echo e($departamento->nombre); ?> | <?php echo e($provincia->nombre); ?> | <?php echo e($distrito->nombre); ?></p>
              </div>
              <?php else: ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Pais</label>
                <p><?php echo e($expediente->Pais); ?></p>
              </div>
              <?php endif; ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Dirección</label>
                <p><?php echo e($expediente->Direccion); ?></p>
              </div>
            </div>
          </div>
          <div class="col">
            <?php if($expediente->TipoEntidad==1): ?>
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
                <p><?php echo e($expediente->Ruc); ?> | <?php echo e($expediente->RazonSocial); ?></p>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Dirección Empresa</label>
                <p><?php echo e($expediente->DireccionEmpresa); ?></p>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>
       
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-datatable-derivar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Derivar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_derivar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="oficina">Oficina</label>
                <select id="oficina" name="oficina" class="form-control" style="width: 100%">
                  <?php if(isset($oficina)): ?>:
                    <option value="<?php echo e($oficina->id); ?>"><?php echo e($oficina->Oficina); ?></option>
                  <?php endif; ?>
                </select>
              </div>
            </div>
            <!-- <div class="col-md-12">
              <div class="form-group">
                <label for="copia">Enviar Copias</label>
                <select id="copia" name="copia[]" class="form-control" multiple="multiple" style="width: 100%"></select>
              </div>
            </div> -->
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_derivar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="derivar">Derivar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-rechazar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="title-datatable">Rechazar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_rechazar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observacion</label>
                <textarea id="observacion" name="observacion" class="form-control observacion_rechazar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-danger" id="rechazar">Rechazar</button>
      </div>
    </div>
  </div>
</div>        
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-validation/dist/jquery.validate.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/validator.setDefaults.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/select2/select2.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')); ?>"></script>
<!-- <script type="text/javascript" src="<?php echo e(asset('js/loader.js')); ?>"></script> -->
<script type="text/javascript">
  var rowid = <?php echo $expediente->RowId; ?>;
</script>
<script type="text/javascript" src="<?php echo e(asset('js/extranet/mesa/revisar.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.extranet', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\tramite\resources\views/extranet/mesa/revisar.blade.php ENDPATH**/ ?>