

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')); ?>">
<style type="text/css">
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
	<div class="col">
  <a href="<?php echo e(url('/extranet/tramite')); ?>" class="btn btn-dark float-right">Ver todos los Trámites</a>
  <!-- <button class="btn btn-word float-right" id="formatos_modal"><i class="fa fa-file-word-o" aria-hidden="true"></i> Formatos</button> -->
		
	</div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header row">
        <h6 class="card-title my-0 col-10">TRÁMITE</h6>
        <div class="col-2">
          <button class="btn btn-warning float-right my-0" id="notificar_modal" title="Notificar"><i class="fas fa-bell"></i></button>
        </div>
        
      </div>
      <div class="card-body pt-0">
      	<div class="row">
      		<div class="col-12">
      			<button class="btn btn btn-light" id="seguimiento_modal"><i class="fas fa-eye"></i> Seguimiento</button>
      		</div>
      		<div class="col-md-4">
            <label class="font-weight-bold mb-0">Estado</label>
            <p><?php echo e($tramite->Estado); ?> | <?php echo e($tramite->FechaEstado); ?></p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Oficina de Trámite</label>
            <p><?php echo e($tramite->Oficina); ?></p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Oficina de Destino</label>
            <p><?php echo e($tramite->OficinaDestino); ?></p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observación</label>
            <p><?php echo e($tramite->Observacion); ?></p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Asunto</label>
            <h5 class="text-primary-extranet font-weight-bold"><?php echo e($expediente->TipoExpediente); ?> | <?php echo e($expediente->Asunto); ?></h5>
          </div>
        </div>
      <?php if($tramite->estado==1 && $tramite->copia==0): ?>
        <button class="btn btn-danger btn-sm" id="rechazar_modal"><i class="fas fa-times"></i> Rechazar</button>
        <button class="btn btn-warning btn-sm" id="observar_modal"><i class="fas fa-eye"></i> Observar</button>
        <button class="btn btn-success btn-sm" id="derivar_modal"><i class="fas fa-share-square"></i> Derivar</button>
        <button class="btn btn-primary btn-sm" id="finalizar_modal"><i class="fas fa-check"></i> Finalizar</button>
        <!-- <button class="btn btn-dark btn-sm" id="archivar_modal"><i class="fas fa-archive"></i> Archivar</button> -->
      <?php elseif($tramite->estado==6): ?>
        <button class="btn btn-warning btn-sm" id="observar_modal"><i class="fas fa-eye"></i> Observar</button>
      <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Requisitos Adjuntos <a href="<?php echo e(url('/extranet/tramite/merge/'.$expediente->RowId)); ?>" class="btn btn-link" target="_blank">Ver todos los archivos</a></h6>
        
      </div>
      <div class="card-body pt-1">
        <div class="row">
          <?php $__currentLoopData = $requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark"><?php echo e($value->nombre); ?> <span class="text-success"><?php echo e($value->observado==1?'(Corregido)':''); ?></span></label>
            <br>
            
            <?php switch($value->tipo):
              case (1): ?>
                  <?php if($value->estado==1): ?>
                    <a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  <?php else: ?>
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  <?php endif; ?>
                <?php break; ?>
              <?php case (2): ?>
                  <?php if($value->estado==1): ?>
                    <a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  <?php else: ?>
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  <?php endif; ?>
                <?php break; ?>
              <?php case (3): ?>.m,
                  <p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Este Documento se presentara fisicamente.</p>
                <?php break; ?>
              <?php case (4): ?>
                  <p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
                <?php break; ?>
              <?php default: ?>
                  
            <?php endswitch; ?>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Documentos Adjuntos - oficina 
          <?php if($tramite->estado==1 && $tramite->copia==0): ?>
          <button class="btn btn-success btn-sm" id="archivo_oficina_modal"><i class="fas fa-plus"></i> Agregar Archivo</button>
          <?php endif; ?>
        </h6>
        
      </div>
      <div class="card-body pt-1">
        <div class="row">
          <?php $__currentLoopData = $adjuntos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark"><?php echo e($value->nombre); ?> <span class="badge badge-pill badge-light"><?php echo e($value->Oficina); ?></span></label>
            <br>
            <a href="<?php echo e(asset('storage/expediente/'.$value->enlace)); ?>" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente <span class="badge badge-info"><?php echo e($expediente->Tipo); ?></span></h6>
        <span class="badge badge-light"></span>
        <span class="badge badge-light"></span>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Solicitud</label>
            <p><?php echo e($expediente->CodigoSolicitud); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p><?php echo e($expediente->CodigoExpediente); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Número Documento</label>
            <p><?php echo e($expediente->NumeroDocumento); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Folios</label>
            <p><?php echo e($expediente->Folio); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p><?php echo e($expediente->FechaReg); ?></p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Estado</label>
            <p><?php echo e($expediente->Estado); ?></p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observación</label>
            <p><?php echo e($expediente->Observacion); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Responsable</h6>
      </div>
      <div class="card-body">
        <?php if($expediente->Tipo=='Externo'): ?>
        <div class="row">
          <div class="col">
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Tipo Persona</label>
                <?php if($expediente->TipoEntidad==1): ?>
                <p>Persona Jurídica</p>
                <?php else: ?>
                <p>Persona Natural</p>
                <?php endif; ?>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0"><?php echo e($expediente->TipoDocumento); ?> | Apellidos y Nombres</label>
                <p><?php echo e($expediente->Responsable); ?></p>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Teléfono</label>
                <p><?php echo e($expediente->Telefono); ?></p>
              </div>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Email</label>
                <p><?php echo e($expediente->Email); ?></p>
              </div>
            </div>
            <div class="row">
              <?php if($expediente->Extranjero==0): ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
                <?php if($expediente->Ubigeo!=NULL): ?>
                <p><?php echo e($departamento->nombre); ?> | <?php echo e($provincia->nombre); ?> | <?php echo e($distrito->nombre); ?></p>
                <?php endif; ?>
              </div>
              <?php else: ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Pais</label>
                <p><?php echo e($expediente->Pais); ?></p>
              </div>
              <?php endif; ?>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Dirección</label>
                <p><?php echo e($expediente->Direccion); ?></p>
              </div>
            </div>
          </div>
          <?php if($expediente->TipoEntidad==1): ?>
          <div class="col">
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
                <p><?php echo e($expediente->Ruc); ?> | <?php echo e($expediente->RazonSocial); ?></p>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Dirección Empresa</label>
                <p><?php echo e($expediente->DireccionEmpresa); ?></p>
              </div>
            </div>
          </div>
          <?php endif; ?>
        </div>
        <?php endif; ?>
        <?php if($expediente->Tipo=='Interno'): ?>
        <div class="col">
          <div class="row">
            <div class="col-md-12">
              <label class="font-weight-bold mb-0">Oficina</label>
              <p><?php echo e($expediente->Oficina); ?> </p>
            </div>
          </div>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-datatable-derivar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Derivar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_derivar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="oficina">Oficina</label>
                <select id="oficina" name="oficina" class="form-control" style="width: 100%">
                  <?php if(isset($oficina)): ?>:
                    <option value="<?php echo e($oficina->id); ?>"><?php echo e($oficina->Oficina); ?></option>
                  <?php endif; ?>
                </select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label for="copia">Enviar Copias</label>
                <select id="copia" name="copia[]" class="form-control" multiple="multiple" style="width: 100%"></select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_derivar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="derivar">Derivar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-rechazar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title">Rechazar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_rechazar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="regresar">Regresar</label>
                <select id="regresar" name="regresar" class="form-control" style="width: 100%"></select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_derivar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-danger" id="rechazar">Rechazar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-observar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-warning text-white">
        <h5 class="modal-title">Observar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_observar">
          <div class="row">
            <?php $__currentLoopData = $all_requisitos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6">
              <div class="form-check">
                <label class="form-check-label">
                  <input class="form-check-input" type="checkbox" name="requisito[]" value="<?php echo e($value->id); ?>">
                  <span class="form-check-sign"></span>
                    <?php echo e($value->nombre); ?>

                </label>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_observar"><?php echo e($tramite->Observacion); ?></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-warning" id="observar">Observar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-finalizar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Finalizar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_finalizar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_finalizar">Recoger licencia dentro de 5 días hábiles.</textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-primary" id="finalizar">finalizar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-archivar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title">Archivar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_archivar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_archivar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-dark" id="archivar">Archivar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-notificar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-warning text-white">
        <h5 class="modal-title">Notificar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_notificar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_notificar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-warning" id="notificar">Notificar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-archivo-oficina" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Subir Archivo Oficina</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_archivo_oficina" enctype="multipart/form-data">
          <div class="row">
            <input type="hidden" name="tipo" value="1">
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="proceso">Tipo Documento</label>
              <select class="form-control" id="proceso" name="proceso">
                <option value="">Seleccione una Opcion</option>
                <?php $__currentLoopData = $procesos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($value->id); ?>"><?php echo e($value->nombre); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="n_documento_o">N° Documento</label>
              <input type="text" class="form-control" id="n_documento_o" name="n_documento">
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="asunto_o">Asunto</label>
              <textarea class="form-control" id="asunto_o" name="asunto" rows="2"></textarea>
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold">Adjuntar archivo</label>
              <input type="file" class="form-control" name="archivo">
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="archivo_oficina">Guardar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-archivo-resultado" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Subir Archivo Resultado</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_archivo_resultado" enctype="multipart/form-data">
          <div class="row">
            <input type="hidden" name="tipo" value="2">
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="expediente_tipo_r">Tipo Documento</label>
              <select class="form-control" id="expediente_tipo_r" name="expediente_tipo">
                <option value="">Seleccione una Opcion</option>
              </select>
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="n_documento_r">N° Documento</label>
              <input type="text" class="form-control" id="n_documento_r" name="n_documento">
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold" for="asunto_r">Asunto</label>
              <textarea class="form-control" id="asunto_r" name="asunto" rows="2"></textarea>
            </div>
            <div class="col-md-12 form-group">
              <label class="font-weight-bold">Adjuntar archivo</label>
              <input type="file" class="form-control" name="archivo">
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="archivo_resultado">Guardar</button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-datatable-seguimiento" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Seguimiento</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <table class="table">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Oficina</th>
                  <th>Accion</th>
                  <td>Observación</td>
                  <th>Oficina Destino</th>
                </tr>
              </thead>
              <tbody id="seguimiento">
                <tr>
                  <th></th>
                  <td></td>
                  <td></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>   


      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')); ?>"></script>

<script type="text/javascript" src="<?php echo e(asset('vendor/jquery-validation/dist/jquery.validate.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/validator.setDefaults.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/select2/select2.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')); ?>"></script>
<!-- <script type="text/javascript" src="<?php echo e(asset('js/loader.js')); ?>"></script> -->
<script type="text/javascript">
  var rowidex = <?php echo $expediente->RowId; ?>;
  var rowidtr = <?php echo $tramite->RowId; ?>;
</script>
<script type="text/javascript" src="<?php echo e(asset('js/extranet/tramite/revisar.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.extranet', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\tramite\resources\views/extranet/tramite/revisar.blade.php ENDPATH**/ ?>