<?php

use App\Http\Controllers\ApiController;
use App\Http\Controllers\FirmaController;
use App\Http\Controllers\OfficeController;

use App\Http\Controllers\Web\IndexController;
use App\Http\Controllers\Web\SeguimientoController;
use App\Http\Controllers\UbigeoController;
use App\Http\Controllers\Extranet\TipoDocumentoController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Extranet\OficinaController;
use App\Http\Controllers\Extranet\EntidadController;
use App\Http\Controllers\Extranet\MesaController;
use App\Http\Controllers\Extranet\TramiteController;
use App\Http\Controllers\Extranet\InternoController;
use App\Http\Controllers\Extranet\ExternoController;
use App\Http\Controllers\Extranet\RequisitoController;
use App\Http\Controllers\Extranet\ServicioController;
use App\Http\Controllers\Extranet\ClaseController;
use App\Http\Controllers\Extranet\ProcesoController;
use App\Http\Controllers\Extranet\ConfiguracionController;
use App\Http\Controllers\Extranet\FeriadoController;
use App\Http\Controllers\Extranet\UsuarioController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/foo', function () {
    Artisan::call('storage:link');
});

Auth::routes();

Route::get('/', function () {
    return view('welcome');
});

Route::get('/home', function () {
    if (Auth::check()) {
        return redirect('/extranet/dashboard');
    } else {
        return redirect('/');
    }
});

Route::get('/email', [IndexController::class, 'email']);
Route::get('/select2departamento', [UbigeoController::class, 'select2departamento']);
Route::get('/select2provincia', [UbigeoController::class, 'select2provincia']);
Route::get('/select2distrito', [UbigeoController::class, 'select2distrito']);
Route::get('/select2/tipo_documento', [TipoDocumentoController::class, 'select2']);

Route::get('/unidad', [IndexController::class, 'unidad']);
Route::get('/proceso', [IndexController::class, 'proceso']);
Route::get('/requisitos/{id}', [IndexController::class, 'requisitos']);

Route::get('/validacion', [IndexController::class, 'validacion']);
Route::get('/validacion/extranjero', [IndexController::class, 'extranjero']);
Route::get('/formulario', [IndexController::class, 'formulario']);
Route::post('/formulario', [IndexController::class, 'store']);
Route::get('/formulario/success/{di}', [IndexController::class, 'success']);

Route::get('/seguimiento', [SeguimientoController::class, 'index']);
Route::get('/seguimiento/validar', [SeguimientoController::class, 'validar']);
Route::get('/seguimiento/expediente/{id}', [SeguimientoController::class, 'expediente']);
Route::post('/seguimiento/expediente/{id}', [SeguimientoController::class, 'store_archivo']);
Route::get('/seguimiento/expediente/seguimiento/{id}', [SeguimientoController::class, 'seguimiento']);

/**
 * Busqueda de Datos de DNI y RUC
 *  */ 
Route::get('/obtenerdni/{dni}', [ApiController::class, 'obtenerDni']);
Route::get('/obtenerruc/{ruc}', [ApiController::class, 'obtenerRuc']);

/**
 * Controlador Firmador
 * para la firma de documentos 
 * - para tramite documentario, y para remitir a exteriores
 * - caracteristicas
 *  - Logo unaj
 *  - Ubicacion deseada
 *  - Disponible para Descarga
 *  - otros.
 */
// Lista los Documentos de su autoría, firmados y por firmar
Route::get('/firmadigital/', [FirmaController::class, 'index']);

// Inicia un modal de carga para iniciar la firma
Route::get('/firmadigital/iniciarfirma', [FirmaController::class, 'iniciarfirma']);



// Obtiene los datos del documento, vista previa, y demas
// parametros necesarios para la firma 
Route::get('/firmadigital/detalle/{id_doc}', [FirmaController::class, 'detalle']);
// obtencion de datos del firmante
//Route::post('/firmadigital/obtenerparametrosjson/{fp_ide}', [FirmaController::class, 'obtenerParametrosJson']);

Route::resource('postres', 'Api\V1\PostresController');
    Route::post('postres/{id}', 'Api\V1\PostresController@update');
    Route::delete('postres/{id}', 'Api\V1\PostresController@destroy');

// Link para subir documentos firmados
//Route::post('/firmadigital/subirdocumentofirmado/{id_doc}', [FirmaController::class, 'subirDocumentoFirmado']);

// Detalles para decir quien firmara el documento
Route::get('/firmadigital/firmador', [FirmaController::class, 'firmadorSelect2']);
// Razon de firma del documento
Route::get('/firmadigital/razon', [FirmaController::class, 'razonSelect2']);
// Razon de firma del documento
Route::get('/firmadigital/orientacion', [FirmaController::class, 'orientacionSelect2']);


Route::post('/firmadigital/guardar', [FirmaController::class, 'store']);


# Carga de Plantillas
Route::get('/plantillainterno', [OfficeController::class, 'obtenerformato']);




Route::middleware(['auth'])->prefix('extranet')->group(function () {
    Route::get('/select2/oficina', [OficinaController::class, 'select2']);
    Route::get('/select2/entidad', [EntidadController::class, 'select2']);
    

    Route::get('/dashboard', function () {
        return view('home');
    });
 
    Route::middleware(['role:SuperAdmin|Admin|MesaPartes|ApoyoMesaPartes'])->group(function () {
        Route::get('/mesa', [MesaController::class, 'index']);
        Route::get('/mesa/lista', [MesaController::class, 'lista']);
        Route::get('/mesa/expediente/{id}', [MesaController::class, 'revisar']);
        Route::put('/mesa/derivar/{id}', [MesaController::class, 'derivar']);
        Route::put('/mesa/rechazar/{id}', [MesaController::class, 'rechazar']);
    });

    Route::middleware(['role:SuperAdmin|Admin|MesaPartes|Funcionario|ApoyoFuncionario'])->group(function () {
        Route::get('/tramite', [TramiteController::class, 'index']);
        Route::get('/tramite/lista', [TramiteController::class, 'lista']);
        Route::get('/tramite/revisar/{id}', [TramiteController::class, 'revisar']);
        Route::get('/tramite/merge/{id}', [TramiteController::class, 'merge']);
        Route::put('/tramite/recibir/{id}', [TramiteController::class, 'recibir']);
        Route::put('/tramite/derivar/{id}', [TramiteController::class, 'derivar']);
        Route::put('/tramite/rechazar/{id}', [TramiteController::class, 'rechazar']);
        Route::put('/tramite/observar/{id}', [TramiteController::class, 'observar']);
        Route::put('/tramite/finalizar/{id}', [TramiteController::class, 'finalizar']);
        Route::put('/tramite/archivar/{id}', [TramiteController::class, 'archivar']);
        Route::put('/tramite/notificar/{id}', [TramiteController::class, 'notificar']);
        Route::post('/tramite/subir_archivo/{id}', [TramiteController::class, 'subir_archivo']);
        Route::get('/tramite/seguimiento/{id}', [TramiteController::class, 'seguimiento']);
        
    });



    Route::prefix('expediente')->group(function () {
        Route::resource('/interno', InternoController::class);
        Route::get('/interno/data/lista', [InternoController::class, 'lista']);
        Route::get('/internocreate/create', [InternoController::class, 'create']);
        Route::resource('/externo', ExternoController::class);
        Route::get('/externo/data/lista', [ExternoController::class, 'lista']);
        Route::get('/externocreate/create', [ExternoController::class, 'create']);
        Route::get('/externo/imprimir/{id}', [ExternoController::class, 'imprimir']);
    });

    Route::prefix('configuracion')->group(function () {
        Route::middleware(['role:SuperAdmin|Admin'])->group(function () {
            Route::resource('/oficina', OficinaController::class);
            Route::resource('/requisito', RequisitoController::class);
            Route::post('/requisito/editar/{id}', [RequisitoController::class, 'editar']);
            Route::resource('/servicio', ServicioController::class);
            Route::resource('/clase', ClaseController::class);
            Route::resource('/proceso', ProcesoController::class);
            Route::get('/proceso/detalle/oficina', [ProcesoController::class, 'proceso']);
            Route::delete('/proceso/detalle/oficina/{id}', [ProcesoController::class, 'proceso_delete']);
            Route::post('/proceso/detalle/oficina/{id}', [ProcesoController::class, 'proceso_store']);
            Route::get('/proceso/detalle/requisito', [ProcesoController::class, 'requisito']);
            Route::delete('/proceso/detalle/requisito/{id}', [ProcesoController::class, 'requisito_delete']);
            Route::post('/proceso/detalle/requisito/{id}', [ProcesoController::class, 'requisito_store']);
            Route::resource('/semana', ConfiguracionController::class);
            Route::resource('/feriado', FeriadoController::class);
        });
        Route::middleware(['role:SuperAdmin'])->group(function () {
            Route::resource('/usuario', UsuarioController::class);
        });
    });

    Route::get('/usuario/datos/perfil', [UsuarioController::class, 'perfil']);
    Route::put('/usuario/save/perfil', [UsuarioController::class, 'perfil_save']);
});

