<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\PostresController;
use App\Http\Controllers\FirmaController;

Route::prefix('v1')->group(function () {
    //Route::resource('postres', PostresController::class);
    //Route::post('postres/{id}', [PostresController::class, 'update']);
    //Route::delete('postres/{id}', [PostresController::class, 'destroy']);
    Route::resource('postres', 'Api\V1\PostresController');
    Route::post('postres/{id}', 'Api\V1\PostresController@update');
    Route::delete('postres/{id}', 'Api\V1\PostresController@destroy');
    
    // obtencion de datos del firmante
    Route::post('parametros/{id}', 'Api\V1\PostresController@parametros');
    // obtencion de datos del firmante
    Route::post('subirpdf/{id}', 'Api\V1\PostresController@subirpdf');
});

// obtencion de datos del firmante
Route::post('/firmadigital/obtenerparametrosjson/{fp_ide}', [FirmaController::class, 'obtenerParametrosJson']);
