@extends('layouts.app')
@section('css')
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection
@section('content')
<div class="container">
  <div class="col-lg-6 col-md-8 ml-auto mr-auto">
    <form class="form" id="formulary">
      <div class="card card-login">
        <div class="card-header ">
          <div class="card-header">
            <h4 class="header text-center mt-0">Validación de Documento de Identidad</h4>
            <hr>
          </div>
        </div>
        <div class="card-body">
          <div class="form-group">
            <label>Documento</label>
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <i class="far fa-address-card"></i>
                </span>
              </div>
              <input type="text" class="form-control" name="documento" placeholder="Documento">
            </div>
          </div>
          <div class="form-group">
            <label>Código de verificación <a href="#" id="informacion"><span class="text-info">¿Dónde se encuentra? <i class="fas fa-question-circle"></i></span></a></label>
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <!-- <i class="nc-icon nc-key-25"></i> -->
                  <i class="far fa-address-card"></i>
                </span>
              </div>
              <input type="numero" name="numero" placeholder="Código" class="form-control">
            </div>
          </div>
          <div class="form-group">
            <div class="d-flex justify-content-center">
              <div class="g-recaptcha" data-sitekey="6LdtAfoSAAAAANbNT_vL65Gsi3WY4eBx3vX2-HUV" data-callback="correctCaptcha"></div>
            </div>
            <label id="recaptchaError" class="d-none invalid-feedback text-danger">Captcha requerido.</label>
          </div>
          <br>
          <button type="button" class="btn btn-success btn-block" id="validacion">
            <i class="fas fa-share-square"></i> VALIDAR DATOS
          </button>
          <div class=" container-fluid">
            <div class="row justify-content-between">
              <div class="col-md-5 col-sm-6">
                <a href="{{url('validacion/extranjero')}}" class="btn btn-link btn-block">
                <i class="fas fa-arrow-right"></i> Soy Extranjero
                </a>
              </div>
            </div>
            
          </div>
        </div>
        <div class="card-footer ">
          <!-- <a href="javascript:;" class="btn btn-success btn-round btn-block mb-3"></a> -->
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
@section('modals')
<div class="modal fade" id="modal-informacion" role="dialog" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title-datatable">Informacion</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <img src="{{asset('img/dni/dni1.jpg')}}" alt="DNI">
          </div>
          <div class="col-md-6">
            <img src="{{asset('img/dni/dni2.jpg')}}" alt="DNI">
          </div>
        </div>   


      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

@endsection
@section('scripts')
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/additional-methods.min.js')}}"></script> -->
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<!-- <script type="text/javascript">
  $.validator.addMethod('filesize', function (value, element, param) {
      console.log(element.files[0].size);
      return this.optional(element) || (element.files[0].size <= param)
  }, 'File size must be less than {0}');
</script> -->

<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<script type="text/javascript" src="{{asset('js/web/validacion.js')}}"></script>
@endsection
