
@extends('layouts.app')
@section('css')
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection
@section('content')
<div class="container">
	@if($observado==1)
		@if($estado==1)
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-danger" role="alert">
					<strong>Alerta!!</strong> Su expediente ha sido observado, deberá adjutar los archivos observados indicados en la parte inferior derecha.
				</div>
			</div>
		</div>
		@endif
	@endif
	@if($expediente->estado==0)
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-info" role="alert">
					<strong>Aviso</strong> Su expediente sera revisado previamente en Mesa de Partes, para verificar su documentos.
				</div>
			</div>
		</div>
	@endif
	@if($expediente->estado==2)
		<div class="row justify-content-center">
			<div class="col-md-6">
				<div class="alert alert-danger" role="alert">
					<strong>Aviso</strong> Su expediente ha sido rechazado, realizar una nueva solicitud.
				</div>
			</div>
		</div>
	@endif
	<div class="row">
		<div class="col-md-7">
			<div class="card">
				<div class="card-header">
					<h6 class="card-title my-0">Revisión de Expediente</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Estado</label>
							@if($expediente->estado==2)
							<p class="font-weight-bold text-danger" style="font-size:20px">{{$expediente->Estado}}</p>
							@elseif($expediente->estado==3)
							<p class="font-weight-bold text-primary" style="font-size:20px">{{$expediente->Estado}}</p>
							@else
							<p class="font-weight-bold" style="font-size:20px">{{$expediente->Estado}}</p>
							@endif
						</div>
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Ultima Observación</label>
							<p class="font-weight-bold text-dark" style="font-size:20px"><i class="fas fa-info-circle"></i> {{$expediente->Observacion}}</p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<table class="table table-striped">
								<thead class="thead-dark">
									<tr>
										<th>#</th>
										<th>Oficina</th>
										<th>Acción</th>
										<th>Observación</th>
										<th>Oficina Destino</th>
									</tr>
								</thead>
								<tbody id="seguimiento" style="font-size:12px">
								</tbody>
							</table>
          				</div>
					</div>
				</div>
			</div>
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos del Expediente</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Código de Solicitud</label>
							<p>{{$expediente->SolicitudCodigo}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Código de Expediente</label>
							<p>{{$expediente->CodigoExpediente}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Número Documento</label>
							<p>{{$expediente->NumeroDocumento}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Folios</label>
							<p>{{$expediente->Folio}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Fecha de Registro</label>
							<p>{{$expediente->FechaReg}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Estado</label>
							<p>{{$expediente->Estado}}</p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Asunto</label>
							<p>{{$expediente->TipoExpediente}} | {{$expediente->Asunto}}</p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Observación</label>
							<p>{{$expediente->Observacion}}</p>
						</div>
					</div>
				</div>
			</div>
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos del Solicitante</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">Tipo Persona</label>
							@if($expediente->TipoEntidad==1)
							<p>Persona Jurídica</p>
							@else
							<p>Persona Natural</p>
							@endif
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<label class="font-weight-bold mb-0">{{$expediente->TipoDocumento}} | Apellidos y Nombres</label>
							<p>{{$expediente->Responsable}}</p>
						</div>
					</div>
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Teléfono</label>
							<p>{{$expediente->Telefono}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Email</label>
							<p>{{$expediente->Email}}</p>
						</div>
					</div>
					<div class="row">
						@if($expediente->Extranjero==0)
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
							<p>{{$departamento->nombre}} | {{$provincia->nombre}} | {{$distrito->nombre}}</p>
						</div>
						@else
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Pais</label>
							<p>{{$expediente->Pais}}</p>
						</div>
						@endif
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Dirección</label>
							<p>{{$expediente->Direccion}}</p>
						</div>
					</div>
				</div>
			</div>
			@if($expediente->TipoEntidad==1)
			<div class="card">
				<div class="card-header">
					<h6 class="card-title">Datos de Empresa</h6>
				</div>
				<div class="card-body">
					<div class="row">
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
							<p>{{$expediente->Ruc}} | {{$expediente->RazonSocial}}</p>
						</div>
						<div class="col-md-6">
							<label class="font-weight-bold mb-0">Dirección</label>
							<p>{{$expediente->DireccionEmpresa}}</p>
						</div>
					</div>
				</div>
			</div>
			@endif
			
		</div>
		<div class="col-md-5">
			<div class="card">
				<div class="card-header">
					<h6 class="card-title my-0">Archivos Adjuntos</h6>
				</div>
				<div class="card-body pt-1">
					<div class="row">
						@foreach($requisitos as $value)
						<div class="col-md-12">
							<label class="font-weight-bold mb-0 text-dark">{{$value->nombre}} <span class="text-success">{{$value->observado==1?'(Observado)':''}}</span></label>
							<br>
							
							@switch($value->tipo)
								@case(1)
										@if($value->estado==1)
											<a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark mt-0" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
										@else
											<p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
										@endif
									@break
								@case(2)
										@if($expediente->estado == 1)
											@if($value->estado==1)
												<a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark mt-0" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
											@else
												<form id="formulary{{$value->id}}">
													<div class='form-group mb-0'>
														<!-- <label class='font-weight-bold text-dark' for='archivoval.orden'>val.orden.- val.nombre</label> -->
														<input type='file' 
															required='true' data-msg-required='Este campo es requerido.'
															filesize='1' data-msg-filesize='El archivo pesa mas de 1M.'
															extension='pdf' data-msg-extension='Solo se permite archivos pdf.'
															id='archivoval.orden' name='archivo' class='d-block'>
													</div>
													<button class="btn btn-success btn-sm subir mb-0" id="{{$value->id}}">Subir</button>
												</form>
											@endif
										@else
										<p class='mx-3 text-info'><i class='fas fa-info-circle'></i> Éste Documento se adjuntará en el proceso del trámite.</p>
										@endif
									@break
								@case(3)
										<p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Éste Documento se presentara físicamente.</p>
									@break
								@case(4)
										<p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
									@break

								@default
										
							@endswitch
						</div>
						@endforeach
					</div>
				</div>
			</div>
		</div>
	</div>
	
</div>
@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/additional-methods.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script>
  $.validator.addMethod('filesize', function (value, element, param) {
      return this.optional(element) || (element.files[0].size <= param * 1000000)
  }, 'File size must be less than {0}');
</script>
<script type="text/javascript">
  var rowidex = {!!$expediente->RowId!!};
</script>

<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<script type="text/javascript" src="{{asset('js/web/seguimiento/expediente.js')}}"></script>
@endsection
