@extends('layouts.app')
@section('css')
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection
@section('content')
<div class="container">
  <div class="col-md-12 ml-auto mr-auto">
    <form class="form" id="formulary">
      <div class="card card-login">
        <div class="card-header ">
          <div class="card-header">
            <h4 class="header text-center mt-0">INICIAR NUEVO TRÁMITE</h4>
            <hr>
          </div>
        </div>
        @if($status)
        <div class="card-body">
          <div class="row">
            <div class="form-group col-md-4">
              <label>Tipo de Persona</label>
              <select class="form-control" name="tipo_persona" id="tipo_persona">
                <option value="">--Seleccionar--</option>
                <option value="0">Persona Natural</option>
                <option value="1">Persona Jurídica</option>
              </select>
            </div>
             
          </div>
          <div id="empresa" style="display:none">
          <h6>Datos de la Empresa</h6>
          <div class="row">
              <div class="form-group col-md-4">
                <label>RUC</label>
                <div class="input-group">
                  <div class="input-group-prepend">
                    <span class="input-group-text">
                      <i class="far fa-building"></i>
                    </span>
                  </div>
                  <input type="text" class="form-control" name="ruc" id="ruc" disabled>
                </div>
                
              </div>
              <div class="col col-sm-4">
                <button type="button" class="btn btn-primary mt-4" id="buscar_ruc"><i class="fas fa-search" id="search_ruc"></i></button>
              </div> 
            </div>
          <div class="row">
            
            <div class="form-group col-md-6">
              <label>Razón Social</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="far fa-building"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="razon_social" id="razon_social" disabled>
              </div>
            </div>
            <div class="form-group col-md-6">
              <label>Dirección de la Empresa</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="far fa-building"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="direccion_empresa" id="direccion_empresa" disabled>
              </div>
            </div>
          </div>
          </div>
        	<h6>Datos Personales</h6>
          <div class="row">
            <div class="col">
              <div class="row">
                <div class="form-group col-md-4 col-sm-8">
                  <label>Documento</label>
                  <div class="input-group">
                    <div class="input-group-prepend">
                      <span class="input-group-text">
                        <i class="far fa-address-card"></i>
                      </span>
                    </div>
                    <input type="text" class="form-control" name="documento" id="documento" value="">
                  </div>
                </div>
                <div class="col col-sm-4">
                  <button type="button" class="btn btn-primary mt-4" id="buscar"><i class="fas fa-search" id="search_dni"></i></button>
                </div> 
              </div>
            </div>
          </div>
          
          <div class="row">
            <div class="form-group col-md-4">
              <label>Apellido Paterno</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="nc-icon nc-single-02"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="paterno" id="paterno" value="">
              </div>
            </div>
            <div class="form-group col-md-4">
              <label>Apellido Materno</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="nc-icon nc-single-02"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="materno" id="materno" value="">
              </div>
            </div>
            <div class="form-group col-md-4">
              <label>Nombres</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="nc-icon nc-single-02"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="nombres" id="nombres" value="">
              </div>
            </div>
          </div>
          <div class="row">
              <div class="form-group col-md-4">
                <label for="departamento">Departamento</label>
                <select class="form-control" name="departamento" id="departamento">
                </select>
              </div>
              <div class="form-group col-md-4">
                <label for="provincia">Provincia</label>
                <select class="form-control" name="provincia" id="provincia">
                </select>
              </div>
              <div class="form-group col-md-4">
                <label for="distrito">Distrito</label>
                <select class="form-control" name="distrito" id="distrito">
                </select>
              </div>
            <div class="form-group col-md-4">
              <label>Dirección</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="fas fa-map-signs"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="direccion" id="direccion">
              </div>
            </div>
            <div class="form-group col-md-4">
              <label>Teléfono Móvil</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="fas fa-mobile-alt"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="telefono" id="telefono">
              </div>
            </div>
            <div class="form-group col-md-4">
              <label>Correo Electrónico</label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="fas fa-at"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="email" id="email">
              </div>
            </div>

          </div>
          <h6>Datos de Trámite</h6>
          <div class="row">
            <div class="form-group col-md-4">
              <label for="tipo_expediente">Tipo de Expediente</label>
              <select class="form-control" name="tipo_expediente" id="tipo_expediente">
                <option value="">-- Seleccionar --</option>
                <option value="1">Tupa</option>
                <option value="2">No Tupa</option>
                <option value="3">Otros</option>
              </select>
            </div>
            <div class="form-group col-md-8 div-unidad" style="display:none">
              <label for="unidad">Unidad Orgánica</label>
              <select class="form-control" name="unidad" id="unidad">
              </select>
            </div>
            <div class="form-group col-md-12 div-proceso" style="display:none">
              <label for="proceso">Procedimiento</label>
              <select class="form-control" name="proceso" id="proceso">
              </select>
            </div>
          </div>
          <div class="row">
            <div class="form-group col-md-12 div-asunto" style="display:none">
              <label for="asunto">Asunto</label>
              <input type="text" class="form-control" name="asunto" id="asunto">
            </div>
            <div class="form-group col-md-4">
              <label for="n_documento">Número Documento</label>
              <input type="text" class="form-control" name="n_documento" id="n_documento">
            </div>
            <div class="form-group col-md-4">
              <label for="folio">Folio Total</label>
              <input type="text" class="form-control" name="folio" id="folio">
            </div>
            <!-- <div class="form-group col-md-4">
              <label>Número Voucher (SECUENCIA)<a href="#" id="informacion"><span class="text-info">¿Dónde se encuentra? <i class="fas fa-question-circle"></i></span></a></label>
              <div class="input-group">
                <div class="input-group-prepend">
                  <span class="input-group-text">
                    <i class="fas fa-file-alt"></i>
                  </span>
                </div>
                <input type="text" class="form-control" name="numero" id="numero">
              </div>
            </div> -->
          </div>
          <h6>Archivos por adjuntar</h6>
          <div class="row">
            <div class="col">
              <div class="card border-primary">
                <div class="card-header">
                  <b>Formatos</b>
                </div>
                <div class="card-body" id="formatos">
                </div>
              </div>
            </div>
          </div>
          <div class="row" id="requisitos">

          </div>
          <button type="button" id="nuevo_archivo" class="btn btn-success"><i class="fas fa-plus"></i>  Agregar otro Archivo</button>
          <div id="adjuntos">
          
          </div>
          <hr>
          <div class="row">
            <div class="form-group col-md-12">
              <label for="observacion">Observación</label>
              <textarea class="form-control" name="observacion" id="observacion"></textarea>
            </div>
          </div>
          <hr>
          <div class="form-group">
            <div class="d-flex justify-content-center">
              <div class="g-recaptcha" data-sitekey="6LdtAfoSAAAAANbNT_vL65Gsi3WY4eBx3vX2-HUV" data-callback="correctCaptcha"></div>
            </div>
            <label id="recaptchaError" class="d-none invalid-feedback text-danger">Captcha requerido.</label>
          </div>
          <div class="form-check text-left">
            <label class="form-check-label">
              <input class="form-check-input" type="checkbox" name="terminos" id="terminos">
              <span class="form-check-sign"></span>
              	He leído y acepto los términos y condiciones de uso; asimismo, autorizo ser notificado al correo electrónico proporcionado <a href="#something">Términos y Condiciones</a>.
            </label>
          </div>
          <button type="button" id="guardar" class="btn btn-success btn-block">
            <i class="fas fa-share-square"></i> Registrar trámite
          </button>
          
        </div>
        @else
        <div class="card-body">
          <div class="alert alert-danger" role="alert">
            <h4 class="alert-heading">Aviso!</h4>
            <p><strong>Motivo de suspensión</strong></p>
            <hr>
            <p class="mb-0">{{$message}}</p>
            <!-- <p class="mb-0"><strong>  Whenever you need to, be sure to use margin utilities to keep things nice and tidy.</p> -->
          </div>
        </div>
        @endif
        <div class="card-footer ">
          <!-- <a href="javascript:;" class="btn btn-success btn-round btn-block mb-3"></a> -->
        </div>
      </div>
    </form>
  </div>
</div>
<div id="clone" class="d-none">
  <div class="row">
    <div class="col-md-8 form-group">
      <label class="font-weight-bold text-dark">Archivos Adicional</label>
      <input type="file" 
      required="true" data-msg-required="Este campo es requerido." 
      filesize="2" data-msg-filesize="El archivo pesa mas de 2M." 
      extension="pdf" data-msg-extension="Solo se permite archivos pdf."
      class="d-block mx-3">
    </div>
    <div class="col-md-4 text-left">
      <button type="button" class="btn btn-danger float-left eliminar_adjunto"><i class="fas fa-times"></i></button>
    </div>
  </div>
</div>

@endsection
@section('modals')
<div class="modal fade" id="modal-informacion" role="dialog" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title-datatable">Informacion</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <img src="{{asset('img/dni/voucher.jpg')}}" alt="Voucher">
          </div>
        </div>   


      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
@endsection
@section('scripts')
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('vendor/SmartWizard-master/dist/js/jquery.smartWizard.min.js')}}"></script> -->
<!-- <script type="text/javascript" src="{{asset('vendor/smartwizard/dist/js/jquery.smartWizard.min.js')}}"></script> -->
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/additional-methods.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script>
  $.validator.addMethod('filesize', function (value, element, param) {
      return this.optional(element) || (element.files[0].size <= param * 1000000)
  }, 'File size must be less than {0}');
</script>

<script type="text/javascript" src="{{asset('vendor/select2/select2.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('vendor/jQuery-Smart-Wizard/js/jquery.smartWizard.js')}}"></script> -->
<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<script type="text/javascript" src="{{asset('js/web/formulario.js')}}"></script>

@endsection
