@extends('layouts.extranet')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection

@section('content')
<div class="row">
  <div class="col">
  <a href="{{url('/extranet/mesa')}}" class="btn btn-dark float-right">Ver todos los Expedientes</a>
    
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Revisión de Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <!-- <div class="col">
            <button class="btn btn btn-light" id="seguimiento_modal"><i class="fas fa-eye"></i> Seguimiento</button>
          </div> -->
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Asunto</label>
            <h5 class="text-primary-extranet font-weight-bold">{{$expediente->TipoExpediente}} | {{$expediente->Asunto}}</h5>
          </div>
        </div>
      @if($expediente->estado==0)
        <button class="btn btn-danger" id="rechazar_modal"><i class="fas fa-times"></i> Rechazar</button>
        <button class="btn btn-success" id="derivar_modal"><i class="fas fa-check"></i> Derivar Expediente</button>
      @endif
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Requisitos Adjuntos</h6>
      </div>
      <div class="card-body pt-1">
        <div class="row">
          @foreach($requisitos as $value)
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark">{{$value->nombre}}</label>
            <br>
            
            @switch($value->tipo)
              @case(1)
                  @if($value->estado==1)
                    <a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  @else
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  @endif
                @break
              @case(2)
                  <p class='mx-3 text-info'><i class='fas fa-info-circle'></i> Este Documento se adjuntara en el proceso del tramite.</p>
                @break
              @case(3)
                  <p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Este Documento se presentara fisicamente.</p>
                @break
              @case(4)
                  <p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
                @break
              @default
                  
            @endswitch
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Solicitud</label>
            <p>{{$expediente->SolicitudCodigo}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p>{{$expediente->CodigoExpediente}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Número Documento</label>
            <p>{{$expediente->NumeroDocumento}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Folios</label>
            <p>{{$expediente->Folio}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p>{{$expediente->FechaReg}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observación</label>
            <p>{{$expediente->Observacion}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Solicitante</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col">
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Tipo Persona</label>
                @if($expediente->TipoEntidad==1)
                <p>Persona Jurídica</p>
                @else
                <p>Persona Natural</p>
                @endif
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">{{$expediente->TipoDocumento}} | Apellidos y Nombres</label>
                <p>{{$expediente->Responsable}}</p>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Teléfono</label>
                <p>{{$expediente->Telefono}}</p>
              </div>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Email</label>
                <p>{{$expediente->Email}}</p>
              </div>
            </div>
            <div class="row">
              @if($expediente->Extranjero==0)
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
                <p>{{$departamento->nombre}} | {{$provincia->nombre}} | {{$distrito->nombre}}</p>
              </div>
              @else
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Pais</label>
                <p>{{$expediente->Pais}}</p>
              </div>
              @endif
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Dirección</label>
                <p>{{$expediente->Direccion}}</p>
              </div>
            </div>
          </div>
          <div class="col">
            @if($expediente->TipoEntidad==1)
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
                <p>{{$expediente->Ruc}} | {{$expediente->RazonSocial}}</p>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Dirección Empresa</label>
                <p>{{$expediente->DireccionEmpresa}}</p>
              </div>
            </div>
            @endif
          </div>
        </div>
       
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-datatable-derivar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Derivar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_derivar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="oficina">Oficina</label>
                <select id="oficina" name="oficina" class="form-control" style="width: 100%">
                  @if(isset($oficina)):
                    <option value="{{$oficina->id}}">{{$oficina->Oficina}}</option>
                  @endif
                </select>
              </div>
            </div>
            <!-- <div class="col-md-12">
              <div class="form-group">
                <label for="copia">Enviar Copias</label>
                <select id="copia" name="copia[]" class="form-control" multiple="multiple" style="width: 100%"></select>
              </div>
            </div> -->
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observación</label>
                <textarea name="observacion" class="form-control observacion_derivar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-success" id="derivar">Derivar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-rechazar" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="title-datatable">Rechazar</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary_rechazar">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label for="observacion">Observacion</label>
                <textarea id="observacion" name="observacion" class="form-control observacion_rechazar"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancelar</button>
        <button type="button" class="btn btn-danger" id="rechazar">Rechazar</button>
      </div>
    </div>
  </div>
</div>        
@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/select2/select2.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('js/loader.js')}}"></script> -->
<script type="text/javascript">
  var rowid = {!!$expediente->RowId!!};
</script>
<script type="text/javascript" src="{{asset('js/extranet/mesa/revisar.js')}}"></script>
@endsection