@extends('layouts.extranet')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="row">
  <div class="col">
  <a href="{{url('/extranet/expediente/interno')}}" class="btn btn-dark float-right">Ver todos los Expedientes</a>
    
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p>{{$expediente->CodigoExpediente}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">N° Documento</label>
            <p>{{$expediente->NumeroDocumento}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p>{{$expediente->FechaReg}}</p>
          </div>
          <!-- <div class="col-md-4">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div> -->
        </div>
        <div class="row">
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Asunto</label>
            <p>{{$expediente->Asunto}}</p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observacion</label>
            <p>{{$expediente->Observacion}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Folio</label>
            <p>{{$expediente->Folio}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Archivos Adjuntos</h6>
      </div>
      <div class="card-body pt-1">
        <div class="row">
          @foreach($adjuntos as $value)
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark">{{$value->nombre}} <span class="badge badge-pill badge-light">{{$value->Oficina}}</span></label>
            <br>
            <a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</div>


@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/select2/select2.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('js/loader.js')}}"></script> -->
<script type="text/javascript">
  var rowid = {!!$expediente->RowId!!};
</script>
@endsection