@extends('layouts.extranet')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/daterangepicker/daterangepicker.css')}}">
@endsection

@section('content')
<div class="row">
  <div class="col-md-12">
    <div class="card">
      <div class="card-header">
        <!-- <h4 class="card-title">DataTables.net</h4> -->
        <div class="container-fluid my-1">
					<div class="row">
						<div class="col-md-4 form-group">
							<label for="estado">Estado</label>
							<select class="form-control" id="estado" name="estado">
								<option value="">Todo</option>
								<option value="0">Pendientes</option>
								<option value="1">En Tramite</option>
								<option value="2">Rechazado</option>
							</select>
						</div>
						<div class="col-md-4 form-group">
							<label for="servicio">Servicio</label>
							<select class="form-control" id="servicio" name="servicio">
								<option value="">Todo</option>
								@foreach($servicio as $value)
								<option value="{{$value->id}}">{{$value->nombre}}</option>
								@endforeach
							</select>
						</div>
						<div class="col-md-4 form-group">
							<label for="fecha">Fecha</label>
							<div id="reportrange" class="div-daterange" style="background: #fff; cursor: pointer; padding: 8px 10px; border: 1px solid #ccc; width: 100%">
								<i class="fa fa-calendar"></i>&nbsp;
								<span></span> <i class="fa fa-caret-down"></i>
							</div>
							<input type="hidden" name="fecha_ini" id="fecha_ini">
							<input type="hidden" name="fecha_fin" id="fecha_fin">
						</div>
					</div>
					<div class="row">
						<div class="col">
							<button class="btn btn-success" id="reporte">Generar Reporte</button>
						</div>
					</div>
  			</div>
      </div>
      <div class="card-body">
        <table class="table table-hover table-bordered dt-responsive" id="table-data" width="100%" cellspacing="0">
          <thead>
            <tr>
              <!-- <th>Opciones</th> -->
              <th>Código Solicitud</th>
              <th>Código Expediente</th>
              <th>Servicio</th>
              <th>Clase</th>
              <th>Entidad</th>
              <th>Fecha Registro</th>
              <th>Estado</th>
            </tr>
          </thead>
          <tbody>
          </tbody>
        </table>
      </div>
    </div>
  </div> 
</div>        
@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script> -->
<!-- <script type="text/javascript" src="{{asset('js/loader.js')}}"></script> -->
<script type="text/javascript" src="{{asset('vendor/moment/min/moment.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/moment/locale/es.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/daterangepicker/daterangepicker.js')}}"></script>
<script type="text/javascript" src="{{asset('js/extranet/expediente/index.js')}}"></script>
@endsection