@extends('layouts.extranet')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2/select2.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/select2-bootstrap4/dist/select2-bootstrap4.min.css')}}">
@endsection

@section('content')
<div class="row">
  <div class="col">
  <a href="{{url('/extranet/expediente/externo')}}" class="btn btn-dark float-right">Ver todos los Expedientes</a>
    
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Requisitos Adjuntos</h6>
        
      </div>
      <div class="card-body pt-1">
        <div class="row">
          @foreach($requisitos as $value)
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark">{{$value->nombre}} <span class="text-success">{{$value->observado==1?'(Corregido)':''}}</span></label>
            <br>
            
            @switch($value->tipo)
              @case(1)
                  @if($value->estado==1)
                    <a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  @else
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  @endif
                @break
              @case(2)
                  @if($value->estado==1)
                    <a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
                  @else
                    <p class='mx-3 text-danger'><i class='fas fa-info-circle'></i> Pendiente por Adjuntar</p>
                  @endif
                @break
              @case(3).m,
                  <p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Este Documento se presentara fisicamente.</p>
                @break
              @case(4)
                  <p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>
                @break
              @default
                  
            @endswitch
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Documentos Adjuntos - oficina 
        </h6>
        
      </div>
      <div class="card-body pt-1">
        <div class="row">
          @foreach($adjuntos as $value)
          <div class="col-md-4">
            <label class="font-weight-bold mb-0 text-dark">{{$value->nombre}} <span class="badge badge-pill badge-light">{{$value->Oficina}}</span></label>
            <br>
            <a href="{{asset('storage/expediente/'.$value->enlace)}}" class="btn btn-sm btn-dark" target="_blank"><i class="fas fa-eye"></i> Ver archivo</a>
          </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-4">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente <a href="{{url('/extranet/expediente/externo/imprimir/'.$expediente->RowId)}}" class="btn btn-link" target="_black">imprimir ticket</a></h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Solicitud</label>
            <p>{{$expediente->SolicitudCodigo}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p>{{$expediente->CodigoExpediente}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Número Documento</label>
            <p>{{$expediente->NumeroDocumento}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Folios</label>
            <p>{{$expediente->Folio}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p>{{$expediente->FechaReg}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Observación</label>
            <p>{{$expediente->Observacion}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-8">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Solicitante</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col">
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Tipo Persona</label>
                @if($expediente->TipoEntidad==1)
                <p>Persona Jurídica</p>
                @else
                <p>Persona Natural</p>
                @endif
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">{{$expediente->TipoDocumento}} | Apellidos y Nombres</label>
                <p>{{$expediente->Responsable}}</p>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Teléfono</label>
                <p>{{$expediente->Telefono}}</p>
              </div>
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Email</label>
                <p>{{$expediente->Email}}</p>
              </div>
            </div>
            <div class="row">
              @if($expediente->Extranjero==0)
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
                <p>{{$departamento->nombre}} | {{$provincia->nombre}} | {{$distrito->nombre}}</p>
              </div>
              @else
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Pais</label>
                <p>{{$expediente->Pais}}</p>
              </div>
              @endif
              <div class="col-md-6">
                <label class="font-weight-bold mb-0">Dirección</label>
                <p>{{$expediente->Direccion}}</p>
              </div>
            </div>
          </div>
          <div class="col">
            @if($expediente->TipoEntidad==1)
            <div class="row">
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Ruc | Apellidos y Nombres</label>
                <p>{{$expediente->Ruc}} | {{$expediente->RazonSocial}}</p>
              </div>
              <div class="col-md-12">
                <label class="font-weight-bold mb-0">Dirección Empresa</label>
                <p>{{$expediente->DireccionEmpresa}}</p>
              </div>
            </div>
            @endif
          </div>
        </div>
       
      </div>
    </div>
  </div>
</div>


@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>

<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/select2/select2.min.js')}}"></script>
<!-- <script type="text/javascript" src="{{asset('js/loader.js')}}"></script> -->
<script type="text/javascript">
  var rowid = {!!$expediente->RowId!!};
</script>
@endsection