@extends('layouts.extranet')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/datatables.net-bs4/css/dataTables.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/datatables.net-responsive-bs4/css/responsive.bootstrap4.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection

@section('content')
<div class="row">
  		<div class="col-md-12">
				<div class="card">
					<div class="card-header">
							<h4 class="card-title">Proceso</h4>
							<div class="row">
								<div class="col-md-10">
								</div>
								<div class="col-md-2">
									<button class="btn btn-primary float-right" id="nuevo"><i class="fa fa-plus"></i> Nuevo</button>
								</div>
							</div>
							<!-- <button class="btn btn-primary float-right" id="nuevo"><i class="fa fa-plus"></i> Nuevo</button> -->
					</div>
      	<div class="card-body">
        	<!-- <div class="table-responsive"> -->
            <table class="table table-hover table-bordered dt-responsive" id="table-data" width="100%" cellspacing="0">
                <thead>
									<tr>
										<th>Opciones</th>
										<th>Id</th>
										<th>Tipo Expediente</th>
										<th>Unidad Organica</th>
										<th>Nombre</th>
									</tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        	<!-- </div> -->
      	</div>
    	</div>
    </div>
</div>
<div class="modal fade" id="modal-datatable" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title-datatable">Modal</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form id="formulary">
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
								<label for="tipo_expediente">Tipo Expediente</label>
								<select class="form-control" id="tipo_expediente" name="tipo_expediente">
									<option value="">-- Seleccionar --</option>
									<option value="0">Interno</option>
									<option value="1">Tupa</option>
									<option value="2">No Tupa</option>
									<option value="3">Otros</option>
								</select>
              </div>
							<div class="form-group div-oficina" style="display:none">
								<label for="unidad">Unidad Orgánica</label>
								<select class="form-control" id="unidad" name="unidad" disabled>
									<option value="">-- Seleccionar --</option>
									@foreach($oficina as $value)
									<option value="{{$value->id}}">{{$value->nombre}}</option>
									@endforeach
								</select>
              </div>
              <div class="form-group">
								<label for="nombre">Nombre</label>
								<textarea id="nombre" name="nombre" class="form-control"></textarea>
              </div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-success" id="guardar">Guardar</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-proceso" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
		<div class="modal-header">
			<h5 class="modal-title" id="title-datatable">Proceso</h5>
			<button class="close" type="button" data-dismiss="modal" aria-label="Close">
			<span aria-hidden="true">&times;</span>
			</button>
		</div>
		<div class="modal-body">
			<div class="card border-primary">
				<div class="card-header pt-0">Nuevo</div>
				<div class="card-body">
					<form id="formulary-proceso">
						<div class="row">
							<div class="col-md-6">
								<div class="form-group">
									<label for="proceso-orden">Orden</label>
									<input type="text" id="proceso-orden" name="orden" class="form-control" aria-required="true">
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group">
									<label for="proceso-oficina">Oficina</label>
									<select id="proceso-oficina" name="oficina" class="form-control">
										<option value="">--Seleccionar--</option>
										@foreach($oficina as $value)
										<option value="{{$value->id}}">{{$value->nombre}}</option>
										@endforeach
									</select>
								</div>
							</div>
						</div>
					</form>
						<button class="btn btn-success" id="guardar-proceso">Guardar</button>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<table class="table table-hover table-bordered dt-responsive" id="table-data-proceso" width="100%" cellspacing="0">
						<thead>
							<tr>
								<th>Opciones</th>
								<th>Orden</th>
								<th>Oficina</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
		</div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-requisito" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
		<div class="modal-header">
			<h5 class="modal-title" id="title-datatable">requisito</h5>
			<button class="close" type="button" data-dismiss="modal" aria-label="Close">
			<span aria-hidden="true">&times;</span>
			</button>
		</div>
		<div class="modal-body">
			<div class="card border-primary">
				<div class="card-header pt-0">Nuevo</div>
				<div class="card-body">
					<form id="formulary-requisito">
						<div class="row">
							<div class="col-md-4">
								<div class="form-group">
									<label for="requisito-orden">Orden</label>
									<input type="text" id="requisito-orden" name="orden" class="form-control" aria-required="true">
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label for="requisito-requisito">Requisito</label>
									<select id="requisito-requisito" name="requisito" class="form-control">
										<option value="">--Seleccionar--</option>
										@foreach($requisito as $value)
										<option value="{{$value->id}}">{{$value->nombre}}</option>
										@endforeach
									</select>
								</div>
							</div>
							<div class="col-md-4">
								<div class="form-group">
									<label for="requisito-tipo">Tipo</label>
									<select id="requisito-tipo" name="tipo" class="form-control">
										<option value="">--Seleccionar--</option>
										<option value="1">Empiezo</option>
										<option value="2">En Tramite</option>
										<option value="3">Fisico</option>
										<option value="4">Requerido</option>
									</select>
								</div>
							</div>
						</div>
					</form>
						<button class="btn btn-success" id="guardar-requisito">Guardar</button>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
					<table class="table table-hover table-bordered dt-responsive" id="table-data-requisito" width="100%" cellspacing="0">
						<thead>
							<tr>
								<th>Opciones</th>
								<th>Orden</th>
								<th>Requisito</th>
								<th>Tipo</th>
							</tr>
						</thead>
						<tbody>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
		</div>
    </div>
  </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net/js/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.16/js/dataTables.bootstrap4.js"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive/js/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/datatables.net-responsive-bs4/js/responsive.bootstrap4.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<script type="text/javascript" src="{{asset('js/extranet/configuracion/proceso.js')}}"></script>
@endsection
