@extends('layouts.entidad')

@section('css')
@endsection

@section('content')
<div class="row">
  <div class="col">
  <a href="{{url('/entidad/tramite')}}" class="btn btn-dark float-right">Ver todos los Tramites</a>
    
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Revisión de Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col">
            <button class="btn btn btn-light" id="seguimiento_modal"><i class="fas fa-eye"></i> Seguimiento</button>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Observación de revisión</label>
            <p>{{$expediente->Observacion}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title my-0">Archivos Adjuntos</h6>
      </div>
      <div class="card-body pt-1">
        <div class="row">
          <div class="col">
            <span class="font-weight-bold">Del Solicitante</span>
            <div class="list-group">
              @foreach($archivo_solicitante as $value)
                <a href="{{asset($value->enlace)}}" class="list-group-item link-download py-1" target="_blank">
                  <i class="fas fa-download"></i> {{$value->nombre}}
                </a>
              @endforeach
            </div>
          </div>
          <div class="col">
            <span class="font-weight-bold text-success">Resultado</span>
            <div class="list-group">
              @foreach($archivo_resultado as $value)
                <a href="{{asset($value->enlace)}}" class="list-group-item d-flex justify-content-between align-items-center link-download py-1" target="_blank">
                  <span><i class="fas fa-download"></i> {{$value->nombre}}</span>
                  <span class="badge badge-light">{{$value->Oficina}}</span>
                </a>
              @endforeach
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Expediente</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Código de Solicitud</label>
            <p>{{$expediente->SolicitudCodigo}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Código de Expediente</label>
            <p>{{$expediente->CodigoExpediente}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">N° Documento</label>
            <p>{{$expediente->NumeroDocumento}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Fecha de Registro</label>
            <p>{{$expediente->FechaReg}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Estado</label>
            <p>{{$expediente->Estado}}</p>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Asunto</label>
            <p>{{$expediente->Asunto}}</p>
          </div>
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Comentario</label>
            <p>{{$expediente->Comentario}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Folio</label>
            <p>{{$expediente->Folio}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-md-6">
    <div class="card">
      <div class="card-header">
        <h6 class="card-title">Datos del Solicitante</h6>
      </div>
      <div class="card-body">
        <div class="row">
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">Tipo de Persona</label>
            <p>{{$expediente->TipoPersona}}</p>
          </div>
        </div>
        @if($expediente->tipo==1)
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">RUC | Razon Social</label>
            <p>{{$expediente->Empresa}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Direccion de la Empresa</label>
            <p>{{$expediente->DireccionEmpresa}}</p>
          </div>
        </div>
        @endif
        <div class="row">
          <div class="col-md-12">
            <label class="font-weight-bold mb-0">{{$expediente->TipoDocumento}} | Apellidos y Nombres</label>
            <p>{{$expediente->Responsable}}</p>
          </div>
        </div>
        <div class="row">
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Teléfono</label>
            <p>{{$expediente->Telefono}}</p>
          </div>
          <div class="col-md-4">
            <label class="font-weight-bold mb-0">Email</label>
            <p>{{$expediente->Email}}</p>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Departamento | Provincia | Distrito</label>
            <p>{{$departamento->nombre}} | {{$provincia->nombre}} | {{$distrito->nombre}}</p>
          </div>
          <div class="col-md-6">
            <label class="font-weight-bold mb-0">Dirección</label>
            <p>{{$expediente->Direccion}}</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="modal-datatable-seguimiento" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title-datatable">Seguimiento</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <table class="table">
              <thead>
                <tr>
                  <td>#</td>
                  <td>Oficina</td>
                  <th>Accion</th>
                  <td>Observacion</td>
                  <td>Oficina Destino</td>
                </tr>
              </thead>
              <tbody id="seguimiento">
                <tr>
                  <th></th>
                  <td></td>
                  <td></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>   


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-success boton1 botones" id="detalles_derivar" disabled="true" style="display: none;">Derivar</button>
        <button type="button" class="btn btn-danger boton2 botones" id="detalles_rechazar" disabled="true" style="display: none;">Rechazar</button>
        <button type="button" class="btn btn-primary boton3 botones" id="detalles_finalizar" disabled="true" style="display: none;">Finalizar</button>
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript">
  var rowidex = {!!$expediente->RowId!!};
</script>
<!-- <script type="text/javascript" src="{{asset('js/loader.js')}}"></script> -->
<script type="text/javascript" src="{{asset('js/entidad/tramite/revisar.js')}}"></script>
@endsection