@extends('layouts.entidad')

@section('css')
<link rel="stylesheet" href="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.css')}}">
<link rel="stylesheet" href="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.css')}}">
@endsection

@section('content')
<div class="row">
  <div class="col-md-8">
    <div class="card ">
      <div class="card-header text-center">
        <h4 class="card-title">Nuevo Trámite</h4>
      </div>
      <div class="card-body ">
        <form id="formulary" enctype="multipart/form-data">
          <div class="container">
            <div class="row">
              <div class="col-md-6 form-group">
                <label class="font-weight-bold" for="expediente_tipo">Tipo Documento</label>
                <select class="form-control" id="expediente_tipo" name="expediente_tipo">
                  @foreach($tipo as $value)
                  <option value="{{$value->id}}">{{$value->nombre}}</option>
                  @endforeach
                </select>
              </div>
            <!-- </div>
            <div class="row"> -->
              <div class="col-md-6 form-group">
                <label class="font-weight-bold" for="n_documento">N° Documento</label>
                <input type="text" class="form-control" id="n_documento" name="n_documento">
              </div>
              <div class="col-md-6 form-group">
                <label class="font-weight-bold" for="n_folio">N° Folio</label>
                <input type="text" class="form-control" id="n_folio" name="n_folio">
              </div>
            </div>
            <div class="row">
              <div class="col-md-12 form-group">
                <label class="font-weight-bold" for="asunto">Asunto</label>
                <textarea class="form-control" id="asunto" name="asunto" rows="2"></textarea>
              </div>
            </div>
            <div class="row" id="archivos">
              <div class="col-md-12 form-group mb-0">
                <label class="font-weight-bold">Adjuntar archivo</label>
                <div class="input-group mb-0">
                  <input type="file" class="form-control" name="archivo[0]"
                  required='true' data-msg-required='Este campo es requerido.'
                  extension='pdf' data-msg-extension='Solo se permite archivos pdf.'
                  filesize='2000000' data-msg-filesize='Archivo debe pesar máximo 2MB.'
                  >
                  <div class="input-group-append">
                    <button class="btn btn-secondary my-0" disabled="true" type="button"><i class="fas fa-times"></i></button>
                  </div>
                </div>
              </div>
            </div>

            <button type="button" id="mas-archivo" class="btn btn-sm btn-primary"><i class="fas fa-plus"></i>Adjuntar más Archivos</button>
            <div class="row">
              <div class="col-md-12 form-group">
                <label class="font-weight-bold" for="comentario">Comentario</label>
                <textarea class="form-control" id="comentario" name="comentario" rows="2"></textarea>
              </div>
            </div>
            <button type="button" class="btn btn-success" id="guardar">Guardar</button>
          </div>

        </form>
      </div>
      <div class="card-footer ">
        <!-- <button type="submit" class="btn btn-info btn-round">Submit</button> -->
      </div>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card">
      <div class="card-header text-center">
        <a href="#" id="informacion" class="text-danger font-weight-bold">¿Como puedo editar un archivo PDF?</a>
        <br>
        <h4 class="card-title my-0">Formatos</h4>
      </div>
      <div class="card-body">
        <div id="accordion">
          @foreach($formatos as $value)
          <div class="card  m-0">
            <div class="card-header p-0" id="heading{{$value->id}}">
              <span class="mb-0" style="font-size: 12px">
                <button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse{{$value->id}}" aria-expanded="false" aria-controls="collapse{{$value->id}}">
                  {{$value->oficina}}
                </button>
              </span>
            </div>
            <div id="collapse{{$value->id}}" class="collapse" aria-labelledby="heading{{$value->id}}" data-parent="#accordion">
              <div class="card-body">
                <div class="list-group">
                  @foreach($value->formatos as $val) 
                  <a href="{{asset('/documentos/formatos_usuario'.$val->archivo)}}" class="list-group-item list-group-item-action" target="_blank"><i class="fas fa-download"></i> {{$val->nombre}}</a>
                  @endforeach
                </div>
              </div>
            </div>
          </div>
          @endforeach
        </div>

      </div>
      <div class="card-footer ">
        <!-- <button type="submit" class="btn btn-info btn-round">Submit</button> -->
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal-datatable-informacion" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="title-datatable">Información</h5>
        <button class="close" type="button" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <p>
            En caso de no poder escanear el documento, puedes editar tu documento con la herramienta del siguiente enlace "Acrobat Reader"  como se muestra en el video:
          </p>
          <iframe width="560" height="315" src="https://www.youtube.com/embed/WPZGrZDI1Ac" frameborder="0" allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
          <p>Para editar un archivo PDF, debe tener instalado el programa "Acrobat Reader", de no ternerlo instalado <a href="https://get.adobe.com/es/reader/" target="_blank">descargar aqui</a></p>
        </div>   


      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" type="button" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<div style="display: none" id="clon">
  <div class="col-md-12 form-group mb-0">
    <label class="font-weight-bold">Adjuntar archivo</label>
    <div class="input-group mb-0">
      <input type="file" class="form-control input_archivo" name="archivo"
      required='true' data-msg-required='Este campo es requerido.'
      extension='pdf' data-msg-extension='Solo se permite archivos pdf.'
      filesize='2000000' data-msg-filesize='Archivo debe pesar máximo 2MB.'
      >
      <div class="input-group-append">
        <button class="btn btn-danger my-0 eliminar" type="button"><i class="fas fa-times"></i></button>
      </div>
    </div>
  </div>
</div>
@endsection
@section('scripts')
<script type="text/javascript" src="{{asset('vendor/jquery-confirm2/dist/jquery-confirm.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/jquery.validate.min.js')}}"></script>
<script type="text/javascript" src="{{asset('vendor/jquery-validation/dist/additional-methods.min.js')}}"></script>
<script type="text/javascript" src="{{asset('js/validator.setDefaults.js')}}"></script>
<script type="text/javascript">
  $.validator.addMethod('filesize', function (value, element, param) {
      console.log(element.files[0].size);
      return this.optional(element) || (element.files[0].size <= param)
  }, 'File size must be less than {0}');
</script>

<script type="text/javascript" src="{{asset('vendor/monkeymonk-jquery.loader/jquery.loader.js')}}"></script>
<script type="text/javascript" src="{{asset('js/entidad/tramite/create.js')}}"></script>
@endsection