@extends('layouts.app')

@section('content')
<div class="container">
  <div class="col-lg-6 col-md-8 ml-auto mr-auto">
    @if(session('data'))
      <div class="alert alert-warning alert-dismissible fade show" role="alert">
      <strong>Aviso!</strong> {{session('data')}}
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    @endif
    @if(session('status'))
      @if(session('status')==true)
      <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Aviso!</strong> Cuenta confirmada, ahora podra iniciar sesión.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @else
      <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Alert!</strong> Se produjo un inconveniente su correo electronico nuevamente y active su cuenta.
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      @endif
    @endif
    <form class="form" method="POST" action="{{ route('entidad.login') }}">
      @csrf
      <div class="card card-login">
        <div class="card-header ">
          <div class="card-header">
            <h4 class="header text-center mt-0">Mesa de Partes Virtual - DRTC-P</h4>
            <hr>
          </div>
        </div>
        <div class="card-body">
          <div class="form-group">
            <label>Documento</label>
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <i class="nc-icon nc-single-02"></i>
                </span>
              </div>
              <input type="text" class="form-control @error('documento') is-invalid @enderror" name="documento" placeholder="Documento">
            </div>
            @error('documento')
              <span class="invalid-feedback d-block" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
            @enderror
          </div>
           <div class="form-group">
            <label>Contraseña</label>
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">
                  <i class="nc-icon nc-key-25"></i>
                </span>
              </div>
              <input type="password" name="password" placeholder="Contraseña" class="form-control @error('password') is-invalid @enderror">
            </div>
            @error('password')
              <span class="invalid-feedback" role="alert">
                  <strong>{{ $message }}</strong>
              </span>
            @enderror
          </div>
          <br>
          <button type="submit" class="btn btn-success btn-block">
            <i class="nc-icon nc-key-25"></i> INICIAR SESIÓN
          </button>
          <div class=" container-fluid">
            <div class="row justify-content-between">
              <div class="col-md-5 col-sm-6">
                <a href="#" class="btn btn-link btn-block">
                 <i class="fas fa-question-circle"></i> Olvidé mi contraseña
                </a>
              </div>
              <div class="col-md-5 col-sm-6">
                <a href="{{url('/entidad/register')}}" class="btn btn-link btn-block">
                  Registrarse <i class="fas fa-arrow-right"></i>
                </a>
              </div>
            </div>
            
          </div>
          <!-- <div class="form-group">
            <div class="form-check">
              <label class="form-check-label">
                <input class="form-check-input" type="checkbox" value="" checked="">
                <span class="form-check-sign"></span>
                Subscribe to newsletter
              </label>
            </div>
          </div> -->
        </div>
        <div class="card-footer ">
          <!-- <a href="javascript:;" class="btn btn-success btn-round btn-block mb-3"></a> -->
        </div>
      </div>
    </form>
  </div>
</div>
@endsection
