$(document).ready(function(){

    $("#tipo_persona").on("change",function(){
        var tipo = $("#tipo_persona").val();
        if(tipo == 1){
            // alert("empresa");
            $("#empresa").show("slow");
            $("#empresa").find("input").prop("disabled",false);
            $("#empresa").find("input").val("");
        }else{
            $("#empresa").hide("slow");
            $("#empresa").find("input").prop("disabled",true);
            $("#empresa").find("input").val("");
            // alert("persona");
        }
    });

    $("#buscar").on("click",function(){
        $('#search_dni').removeClass('fa-search');
        $('#search_dni').addClass('fa-spinner fa-spin');
        
        var dni = $("#documento").val();
        

        $.ajax({
            type: "GET",
            dataType: "json",
            url: base_url+"/obtenerdni/"+dni,
            success:function(data){
                $("#paterno").val(data.body.apePaterno);
                $("#materno").val(data.body.apeMaterno);
                $("#nombres").val(data.body.preNombres);
                $('#search_dni').removeClass('fa-spinner fa-spin');
                $('#search_dni').addClass('fa-search');
                
            },
            error:function(result){
                console.log(result);
                alert('Error de DNI, verifique e intente nuevamente');
                $('#search_dni').removeClass('fa-spinner fa-spin');
                $('#search_dni').addClass('fa-search');
            }
        });
    });

    $("#buscar_ruc").on("click",function(){
        $('#search_ruc').removeClass('fa-search');
        $('#search_ruc').addClass('fa-spinner fa-spin');

        var ruc = $("#ruc").val();
        

        $.ajax({
            type: "GET",
            dataType: "json",
            url: base_url+"/obtenerruc/"+ruc,
            success:function(data){
                $("#razon_social").val(data.body.datosContribuyente.desRazonSocial);
                $("#direccion_empresa").val(data.body.datosContribuyente.desDireccion);

                $('#search_ruc').removeClass('fa-spinner fa-spin');
                $('#search_ruc').addClass('fa-search');
                
            },
            error:function(result){
                alert('Error de RUC, intente nuevamente.');
                $('#search_ruc').removeClass('fa-spinner fa-spin');
                $('#search_ruc').addClass('fa-search');
            }
        });
    });
    
/*
    $("#buscar").on("click",function(){
        var dni = $("#documento").val();
        $.ajax({
            type: "GET",
            dataType: "json",
            url: base_url+"/api/only-dni/"+dni,
            success:function(data){
                $("#paterno").val(data.result.paterno);
                $("#materno").val(data.result.materno);
                $("#nombres").val(data.result.nombres);
                
            },
            error:function(result){

            }
        });
    });

*/
    $("#informacion").on("click",function(){

		$("#modal-informacion").modal("show");
	});
    // if(!query){
        $("#provincia").prop('disabled', true);
        $("#distrito").prop('disabled', true);

    // }

	var departamento = 0;
    var provincia = 0;

    $("#departamento").select2({
        allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un departamento",
        ajax: {
            url: base_url+"/select2departamento/",
            dataType: 'json',
            // delay: 250,
            data: function (params) {
                return {
                    q: params.term 
                };
            },
            processResults: function (data) {
                return {
                    results: data.items
                };
            },

            cache: true
        },
        minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#departamento").removeClass('is-invalid')
        $("#provincia").prop('disabled', false);

        departamento = e.params.data.id;
        $("#provincia").val('').trigger('change');
        $("#distrito").val('').trigger('change');

        $("#distrito").prop('disabled', true);
    });

    $("#provincia").select2({
      allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un provincia",
      ajax: {
        url:base_url+"/select2provincia/",
        dataType: 'json',
        // delay: 250,
        data: function (params) {
            return {
                q: params.term,
                departamento:departamento 
            };
        },
        processResults: function (data) {
            return {
                results: data.items
            };
        },

        cache: true
    },
    minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#provincia").removeClass('is-invalid')
        $("#distrito").prop('disabled', false);
        provincia = e.params.data.id;
        $("#distrito").val('').trigger('change');
        console.log(e.params.data);
    });

    $("#distrito").select2({
      allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un distrito",
      ajax: {
        url:base_url+"/select2distrito",
        dataType: 'json',
        // delay: 250,
        data: function (params) {
            return {
                q: params.term,
                departamento:departamento, 
                provincia:provincia 
            };
        },
        processResults: function (data) {
            return {
                results: data.items
            };
        },

        cache: true
    },
    minimumInputLength: -1
    })
    .on("select2:select", function (e) {
    	$("#distrito").removeClass('is-invalid')
        // $("#distrito").prop('disabled', false);
        console.log(e.params.data);
    });

    ids = 0; 

    $("#nuevo_archivo").on("click",function(){
        // console.log("nuevo");
        $("#clone div:eq(0)").find("label").attr("for","adjunto"+ids);
        $("#clone div:eq(0)").find("input").attr("id","adjunto"+ids);
        $("#clone div:eq(0)").find("input").attr("name","adjunto["+ids+"]");
        $("#clone div:eq(0)").clone().appendTo("#adjuntos");
        ids++;
    });

    $("#adjuntos").delegate(".eliminar_adjunto","click",function(e){
        $(this).parent().parent().remove();
        // e.preventDefault();
    });

    $("#tipo_expediente").on("change",function(){
        // console.log("gl");
        // alert("hola");
        var expediente = $("#tipo_expediente").val();
        $("#requisitos").html('');
        $("#formatos").html('');
        // console.log(expediente);
        switch (expediente) {
            case '1':
                $(".div-unidad").show();
                $("#unidad").removeClass("is-valid is-invalid");
                $("#unidad").prop("disabled",false);

                $(".div-proceso").show();
                $("#proceso").prop("disabled",false);
                $(".div-asunto").hide();
                $("#asunto").prop("disabled",true);

                $("#proceso").html("");
                $("#proceso").removeClass("is-valid is-invalid");
                
                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: base_url+"/unidad",
                    success:function(data){
                        html = '<option value="">-- Seleccionar --</option>';
                        $.each( data, function( key, value ) {
                            html += '<option value="'+value.id+'">'+value.nombre+'</option>';
                        });
                        $("#unidad").html(html);
                        
                    },
                    error:function(result){
        
                    }
                });
                break;
            case '2':
                $(".div-unidad").hide();
                $("#unidad").prop("disabled",true);
                $(".div-proceso").show();
                $("#proceso").prop("disabled",false);
                $(".div-asunto").show();
                $("#asunto").prop("disabled",false);
                
                $("#proceso").html("");
                $("#proceso").removeClass("is-valid is-invalid");

                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: base_url+"/proceso?tipo=2",
                    success:function(data){
                        html = '<option value="">-- Seleccionar --</option>';
                        $.each( data, function( key, value ) {
                            html += '<option value="'+value.id+'">'+value.nombre+'</option>';
                        });
                        $("#proceso").html(html);
                        $("#proceso").removeClass("is-valid is-invalid");
                        
                    },
                    error:function(result){
    
                    }
                });

                break;
            case '3':
                $(".div-unidad").hide();
                $("#unidad").prop("disabled",true);
                $(".div-proceso").hide();
                $("#proceso").prop("disabled",false);
                
                $(".div-asunto").show();
                $("#asunto").prop("disabled",false);

                $.ajax({
                    type: "GET",
                    dataType: "json",
                    url: base_url+"/proceso?tipo=3",
                    success:function(data){
                        // html = '';
                        // $.each( data, function( key, value ) {
                        proceso = '<option value="'+data.proceso.id+'" selected>'+data.proceso.nombre+'</option>';
                        $("#proceso").html(proceso);
                        $("#proceso").removeClass("is-valid is-invalid");

                        html = "";
                        botones = "";
                        $.each(data.formatos,function(i,val){
                            botones += '<a href="storage/formatos'+val.enlace+'" class="btn btn-danger" target="_blank">'+val.nombre+'</a>';
                        });
                        $("#formatos").html(botones);
                        $.each(data.requisitos,function(i,val){
                            html += "<div class='col-md-12 form-group mx-2'>"+
                                        "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
                                        "<input type='file' "+
                                        "required='true' data-msg-required='Este campo es requerido.'"+
                                        "filesize='2' data-msg-filesize='El archivo pesa mas de 2M.'"+
                                        "extension='pdf' data-msg-extension='Solo se permite archivos pdf.'"+
                                        "id='archivo"+val.orden+"' name='archivo["+val.id+"]' class='d-block mx-3'>"+
                                    "</div>"
                            // botones += '<a href="''" class="btn btn-danger">Boton</a>';
                        });
                        $("#requisitos").html(html);
                        
                    },
                    error:function(result){
    
                    }
                });

                break;
        
            default:
                $(".div-unidad").hide();
                $(".div-proceso").hide();
                $(".div-asunto").hide();
                $("#asunto,#unidad,#proceso").prop("disabled",true);
                break;
        }
        
        // $.ajax({
        //     type: "GET",
        //     dataType: "json",
        //     url: base_url+"/servicio/"+$("#clase").val(),
        //     success:function(data){
        //         html = '<option value="">-- Seleccionar --</option>';
        //         $.each( data, function( key, value ) {
        //             html += '<option value="'+value.id+'">'+value.nombre+'</option>';
        //         });
        //         $("#servicio").html(html);
        //         $("#servicio").removeClass("is-valid is-invalid");
        //     },
        //     error:function(result){

        //     }
        // });
    });
    $("#unidad").on("change",function(){
        var unidad = $("#unidad").val();
        $("#requisitos").html('');
        $("#formatos").html('');

        $("#proceso").html("");
        $("#proceso").removeClass("is-valid is-invalid");
        // if(unidad!=""){
            $.ajax({
                type: "GET",
                dataType: "json",
                url: base_url+"/proceso?tipo=1&unidad="+unidad,
                success:function(data){
                    html = '<option value="">-- Seleccionar --</option>';
                    $.each( data, function( key, value ) {
                        html += '<option value="'+value.id+'">'+value.nombre+'</option>';
                    });
                    $("#proceso").html(html);
                    $("#proceso").removeClass("is-valid is-invalid");
                    
                },
                error:function(result){

                }
            });
        // }else{
            
        // }
    });
    $("#proceso").on("change",function(){
        var proceso = $("#proceso").val();
        $.ajax({
            type: "GET",
            dataType: "json",
            url: base_url+"/requisitos/"+proceso,
            success:function(data){
                html = "";
                botones = "";
                $.each(data.formatos,function(i,val){
                    botones += '<a href="storage/formatos'+val.enlace+'" class="btn btn-danger" target="_blank">'+val.nombre+'</a>';
                });
                $("#formatos").html(botones);
                $.each(data.requisitos,function(i,val){
                    html += "<div class='col-md-12 form-group mx-2'>"+
                                "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
                                "<input type='file' "+
                                "required='true' data-msg-required='Este campo es requerido.'"+
                                "filesize='2' data-msg-filesize='El archivo pesa mas de 2M.'"+
                                "extension='.pdf' data-msg-extension='Solo se permite archivos pdf.'"+
                                "id='archivo"+val.orden+"' name='archivo["+val.id+"]' class='d-block mx-3' accept='.pdf'>"+
                            "</div>"
                    // botones += '<a href="''" class="btn btn-danger">Boton</a>';
                });
                $("#requisitos").html(html);
                
            },
            error:function(result){

            }
        });
    });
    // $("#servicio").on("change",function(){
    //     // console.log("gl");
    //     $.ajax({
    //         type: "GET",
    //         dataType: "json",
    //         url: base_url+"/requisitos/"+$("#servicio").val(),
    //         success:function(data){
    //             html = "";
    //             $.each(data,function(i,val){
    //                 switch (val.tipo) {
    //                     case 1:
    //                         html += "<div class='col-md-12 form-group mx-2'>"+
    //                                     "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
    //                                     "<input type='file' "+
    //                                     "required='true' data-msg-required='Este campo es requerido.'"+
    //                                     "filesize='2' data-msg-filesize='El archivo pesa mas de 2M.'"+
    //                                     "extension='pdf' data-msg-extension='Solo se permite archivos pdf.'"+
    //                                     "id='archivo"+val.orden+"' name='archivo["+val.id+"-"+val.tipo+"]' class='d-block mx-3'>"+
    //                                 "</div>"
    //                       break;
    //                     case 2:
    //                         html += "<div class='col-md-12 form-group mx-2'>"+
    //                                     "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
    //                                     "<p class='mx-3 text-info'><i class='fas fa-info-circle'></i> Este Documento se adjuntara en el proceso del tramite.</p>"+
    //                                     "<input type='hidden' name='archivo["+val.id+"-"+val.tipo+"]'>"+
    //                                 "</div>"
    //                         break;
    //                     case 3:
    //                         html += "<div class='col-md-12 form-group mx-2'>"+
    //                                     "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
    //                                     "<p class='mx-3 text-success'><i class='fas fa-info-circle'></i> Este Documento se presentara físicamente.</p>"+
    //                                     "<input type='hidden' name='archivo["+val.id+"-"+val.tipo+"]'>"+
    //                                 "</div>"
    //                         break;
    //                     case 4:
    //                         html += "<div class='col-md-12 form-group mx-2'>"+
    //                                     "<label class='font-weight-bold text-dark' for='archivo"+val.orden+"'>"+val.orden+".- "+val.nombre+"</label>"+
    //                                     "<p class='mx-3 text-primary'><i class='fas fa-info-circle'></i> Aprobar el requisito.</p>"+
    //                                     "<input type='hidden' name='archivo["+val.id+"-"+val.tipo+"]'>"+
    //                                 "</div>"
    //                         break;
    //                     default:
    //                       break;
    //                   }
    //             });
    //             $("#requisitos").html(html);
    //         },
    //         error:function(result){

    //         }
    //     });
    // });

	var validator = $("#formulary").validate({
        rules:{
            'tipo_persona':{
                required:true
            },
            'ruc':{
                required:true,
                number:true,
                minlength:11,
                maxlength:11
            },
            'razon_social':{
                required:true
            },
            'direccion_empresa':{
                required:true
            },
            'documento':{
                required:true,
                number:true,
                minlength:8,
                maxlength:8
            },
            'paterno':{
                required:true
            },
            'materno':{
                required:true
            },
            'nombres':{
                required:true
            },
            'departamento':{
                required:true
            },
            'provincia':{
                required:true
            },
            'distrito':{
                required:true
            },
            'direccion':{
                required:true
            },
            'pais':{
                required:true
            },
            'telefono':{
                required:true,
                number:true,
                minlength:9,
                maxlength:9
            },
            'email':{
                required:true,
                email:true
            },
            'tipo_expediente':{
                required:true,
            },
            'unidad':{
                required:true,
            },
            'proceso':{
                required:true,
            },
            'asunto':{
                required:true,
            },
            'numero':{
                required:true,
                number:true,
                minlength:7,
                maxlength:7
            },
            'terminos':{
                required:true
            }
            
        },
        messages:{
            'tipo_persona':{
                required:"Este campo es requerido."
            },
            'ruc':{
                required:"Este campo es requerido.",
                number: "Solo se permiten numeros.",
                minlength: "Minimo como 11 caracteres.",
                maxlength: "Maximo como 11 caracteres."
            },
            'razon_social':{
                required:"Este campo es requerido."
            },
            'direccion_empresa':{
                required:"Este campo es requerido."
            },
            'documento':{
                required:"Este campo es requerido.",
                number: "Solo se permiten numeros.",
                minlength: "Minimo como 8 caracteres.",
                maxlength: "Maximo como 8 caracteres."
            },
            'paterno':{
                required:"Este campo es requerido."
            },
            'materno':{
                required:"Este campo es requerido."
            },
            'nombres':{
                required:"Este campo es requerido."
            },
            'departamento':{
                required:"Este campo es requerido."
            },
            'provincia':{
                required:"Este campo es requerido."
            },
            'distrito':{
                required:"Este campo es requerido."
            },
            'pais':{
                required:"Este campo es requerido."
            },
            'direccion':{
                required:"Este campo es requerido."
            },
            'telefono':{
                required:"Este campo es requerido.",
                number: "Solo se permiten numeros.",
                minlength: "Minimo como 9 caracteres.",
                maxlength: "Maximo como 9 caracteres."
            },
            'email':{
                required:"Este campo es requerido.",
                email:"Formato invalido"
            },
            'tipo_expediente':{
                required:"Este campo es requerido.",
            },
            'unidad':{
                required:"Este campo es requerido.",
            },
            'proceso':{
                required:"Este campo es requerido.",
            },
            'asunto':{
                required:"Este campo es requerido.",
            },
            'numero':{
                required:"Este campo es requerido.",
                number: "Solo se permiten numeros.",
                minlength: "Minimo como 7 caracteres.",
                maxlength: "Maximo como 7 caracteres."
            },
            'terminos':{
                required:"Este campo es requerido."
            }
        }
    });

    $("#guardar").on("click",function(){
        var response = grecaptcha.getResponse();
    	var validar = validator.form();
        if (response.length == 0) {
			$('#recaptchaError').removeClass('d-none');
			$('#recaptchaError').addClass('d-block');
		}else {
			$('#recaptchaError').addClass('d-none');
            $('#recaptchaError').removeClass('d-block');
            if(validar == true){
                // data = $("#formulary").serialize();
                var data = new FormData($("#formulary")[0]);
                // load.open();
                $('.content').loader('show');
                $.ajax({
                    type: "POST",
                    dataType: "json",
                    url: base_url+"/formulario",
                    cache: false,
                    contentType: false,
                    processData: false,
                    data:data,
                    success:function(data){
                    // console.log(data);
                        $('.content').loader('hide');
                        if(data.status == true){
                            $(location).attr('href', base_url+'/formulario/success/'+data.id);
                        }else{
                            $.confirm({
                                title: 'Aviso!',
                                content: data['message'],
                                type: 'orange',
                                theme: 'modern',
                                closeIcon: true,
                                icon: 'fas fa-exclamation-triangle',
                                buttons: {
                                confirm: {
                                    text:"Intentar de nuevo",
                                    btnClass: 'btn-green',
                                    action: function(){
                                    }
                                },
                                cancel:{
                                    text:"Salir",
                                    action:function(){
                                        
                                    }
                                }
                                }
                            });
                        }
                        // table.draw();
                        // $('#modal-datatable').modal('hide');
                    },
                    error:function(result){

                    }
                });
            }
        }
    })
});