$(document).ready(function(){

	var table = $('#table-data').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/tramite/lista',
			data: function (d) {
	            d.estado = $('#estado').val();
				d.servicio = $('#servicio').val();
	        }
		},
		columns:[
			{data:'Botones',name:'Botones'},
			{data:'CodigoExpediente',name:'CodigoExpediente'},
			{data:'Estado',name:'Estado'},
			{data:'TipoExpediente',name:'TipoExpediente'},
			{data:'Proceso',name:'Proceso'},
			{data:'Asunto',name:'Asunto'},
			{data:'Observacion',name:'Observacion'},
			{data:'Oficina',name:'Oficina'},
			{data:'Responsable',name:'Responsable'},
			{data:'FechaReg',name:'FechaReg'},
		],
	    rowCallback: function( row, data, index ) {
	    	// $('td:eq(0)', row).html('<a href="/extranet/mesa/expediente/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i>Revisar</a>');
			

	    	var btn = "";
	    	switch(parseInt(data.EstadoNumero)) {
				case 0:
					btn += '<a href="'+data.RowId+'" class="recibir btn btn-info btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					$(row).addClass("table-info");
					break;
				case 1:
					btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
					// $(row).addClass("table-info");
					break;
				case 2:
					btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
					$(row).addClass("table-success");
					// btn += '<a href="'+data.RowId+'" class="recibir btn btn-dark btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					break;
				case 3:
					btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
					$(row).addClass("table-danger");
					// btn += '<a href="'+data.RowId+'" class="recibir btn btn-dark btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					break;
				case 4:
					btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
					$(row).addClass("table-primary");
					// btn += '<a href="'+data.RowId+'" class="recibir btn btn-dark btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					break;
				case 5:
					btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
					$(row).addClass("table-secondary");
					// btn += '<a href="'+data.RowId+'" class="recibir btn btn-dark btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					break;
				case 6:
						btn += '<a href="'+base_url+'/extranet/tramite/revisar/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i> Revisar</a> ';
						$(row).addClass("table-warning");
					// btn += '<a href="'+data.RowId+'" class="recibir btn btn-dark btn-sm col-xs-4" title="Recibir">Recibir</a> ';
					break;
				default:
					break;
			    // code block
			}

			$('td:eq(0)', row).html(btn);
			$('td:eq(0)', row).delegate('.recibir','click',function(e){ 
				href = $(this).attr('href');
		
				$.confirm({
                    title: '',
                    content: 'Recibir Expediente',
                    type: 'blue',
                    theme: 'modern',
                    closeIcon: true,
                    icon: 'fas fa-check',
                    buttons: {
                      confirm: {
                          text:"Recibir",
                          btnClass: 'btn-blue',
                          action: function(){
							$('.content').loader('show');
                          	$.ajax({
				                type: "PUT",
				                dataType: "json",
				                url: base_url+"/extranet/tramite/recibir/"+href,
				                success:function(data){
									$('.content').loader('hide');
				                    if(data.status == true){
				                        // table.draw();
				                        $.confirm({
				                            title: 'Satisfactorio',
				                            content: data['message'],
				                            type: 'green',
				                            theme: 'modern',
				                            // closeIcon: true,
				                            icon: 'fas fa-check',
				                            buttons: {
				                              confirm: {
				                                  text:"Aceptar",
				                                  btnClass: 'btn-green',
				                                  action: function(){
				                                    table.draw();
				                                  }
				                              }
				                            }
				                        });

				                    }else{
				                        $.confirm({
				                            title: 'Error!',
				                            content: data['message'],
				                            type: 'orange',
				                            theme: 'modern',
				                            closeIcon: true,
				                            icon: 'fas fa-exclamation-triangle',
				                            buttons: {
				                              confirm: {
				                                  text:"Intentar de nuevo",
				                                  btnClass: 'btn-green',
				                                  action: function(){
				                                  }
				                              },
				                              cancel:{
				                                  text:"Salir",
				                                  action:function(){
				                                     
				                                  }
				                              }
				                            }
				                        });
				                    }
				                },
				                error:function(result){

				                }
				            });	
                          }
                      },
                      cancel:{
                          text:"Salir",
                          action:function(){
                             
                          }
                      }
                    }
                });
				e.preventDefault();
			});

		},
	    "orderable": false,
	    "targets": 'no-sort',
	});

	$("#estado,#servicio").on("change",function(){
		table.draw();
	});
});