$(document).ready(function(){

	var oficinaSelect2 = $("#oficina").select2({
        allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione una Oficina",
        ajax: {
            url:base_url+"/extranet/select2/oficina",
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.items
                };
            },

          cache: true
        },
        minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#oficina").removeClass('is-invalid')
        // $("#distrito").prop('disabled', false);
        // console.log(e.params.data);
    });

	$("#derivar_modal").on("click",function(){
		$('#modal-datatable-derivar').modal('show');

	});
    $("#aprobar_modal1").on("click",function(){
		$.confirm({
			title: '',
			content: '¿Esta seguro de aprobar la solicitud?',
			type: 'green',
			theme: 'modern',
			// closeIcon: true,
			icon: 'fas fa-question',
			buttons: {
				confirm: {
					text:"Aceptar",
					btnClass: 'btn-green',
					action: function(){
						$('.content').loader('show');
						$.ajax({
							type: "PUT",
							dataType: "json",
							url: base_url+"/extranet/mesa/derivar/"+rowid,
							// data:data,
							success:function(data){
								$('.content').loader('hide');
								  if(data.status == true){
									$.confirm({
										title: 'Satisfactorio',
										content: data['message'],
										type: 'green',
										theme: 'modern',
										// closeIcon: true,
										icon: 'fas fa-check',
										buttons: {
										  confirm: {
											  text:"Aceptar",
											  btnClass: 'btn-green',
											  action: function(){
												  location.reload();
											  }
										  }
										}
									});
			
								}else{
									$.confirm({
										title: 'Error!',
										content: data['message'],
										type: 'orange',
										theme: 'modern',
										closeIcon: true,
										icon: 'fas fa-exclamation-triangle',
										buttons: {
										  confirm: {
											  text:"Intentar de nuevo",
											  btnClass: 'btn-green',
											  action: function(){
												  // table.draw();
											  }
										  }
										}
									});
								}
								// $('#modal-datatable-derivar').modal('hide');
							},
							error:function(result){
			
							}
						});
					}
				},
				cancel:{
					text:"Salir",
					action:function(){
					   
					}
				}
			}
		});
                
    });
    $("#rechazar_modal").on("click",function(){
    	$('#modal-datatable-rechazar').modal('show');
                
    });

	var validator_derivar = $("#formulary_derivar").validate({
        rules:{
            'oficina':{
                required:true
            }          
        },
        messages:{
            'oficina':{
                required:"Este campo es requerido."
            }
        }
    });
    var validator_rechazar = $("#formulary_rechazar").validate({
        rules:{
            'observacion':{
                required:true
            }           
        },
        messages:{
            'observacion':{
                required:"Este campo es requerido."
            }
        }
    });

	$("#derivar").on("click",function(){
    	var validar = validator_derivar.form();
    	if(validar == true){
    		data = $("#formulary_derivar").serialize();
    		// load.open();
			$('.content').loader('show');
			$.ajax({
		        type: "PUT",
		        dataType: "json",
		        url: base_url+"/extranet/mesa/derivar/"+rowid,
		        data:data,
		        success:function(data){
					$('.content').loader('hide');
		          	if(data.status == true){
						$.confirm({
							title: 'Satisfactorio',
							content: data['message'],
							type: 'green',
							theme: 'modern',
							// closeIcon: true,
							icon: 'fas fa-check',
							buttons: {
							  confirm: {
							      text:"Aceptar",
							      btnClass: 'btn-green',
							      action: function(){
							      	location.reload();
							      }
							  }
							}
						});

			        }else{
			            $.confirm({
							title: 'Error!',
							content: data['message'],
							type: 'orange',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-exclamation-triangle',
							buttons: {
							  confirm: {
							      text:"Intentar de nuevo",
							      btnClass: 'btn-green',
							      action: function(){
							          // table.draw();
							      }
							  },
							  cancel:{
							      text:"Salir",
							      action:function(){
							         
							      }
							  }
			                }
			            });
			        }
	                $('#modal-datatable-derivar').modal('hide');
		        },
		        error:function(result){

		        }
		    });
    	}
    });
    $("#rechazar").on("click",function(){
    	var validar = validator_rechazar.form();
    	if(validar == true){
    		data = $("#formulary_rechazar").serialize();
    		// load.open();
			$('.content').loader('show');
			$.ajax({
		        type: "PUT",
		        dataType: "json",
		        url: base_url+"/extranet/mesa/rechazar/"+rowid,
		        data:data,
		        success:function(data){
					$('.content').loader('hide');
		          if(data.status == true){
						$.confirm({
							title: 'Satisfactorio',
							content: data['message'],
							type: 'green',
							theme: 'modern',
							// closeIcon: true,
							icon: 'fas fa-check',
							buttons: {
							  confirm: {
							      text:"Aceptar",
							      btnClass: 'btn-green',
							      action: function(){
							      	location.reload();
							      }
							  }
							}
						});

			        }else{
			            $.confirm({
							title: 'Error!',
							content: data['message'],
							type: 'orange',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-exclamation-triangle',
							buttons: {
							  confirm: {
							      text:"Intentar de nuevo",
							      btnClass: 'btn-green',
							      action: function(){
							          // table.draw();
							      }
							  },
							  cancel:{
							      text:"Salir",
							      action:function(){
							         
							      }
							  }
			                }
			            });
			        }
	                $('#modal-datatable-rechazar').modal('hide');
		        },
		        error:function(result){

		        }
		    });
    	}
    })
});