$(document).ready(function(){

	var table = $('#table-data').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/expediente/interno/data/lista',
			data: function (d) {
	            d.estado = $('#estado').val();
	        }
		},
		columns:[
			{data:'Botones',name:'Botones'},
			// {data:'SolicitudCodigo',name:'SolicitudCodigo'},
			{data:'CodigoExpediente',name:'CodigoExpediente'},
			{data:'NumeroDocumento',name:'NumeroDocumento'},
			{data:'FechaReg',name:'FechaReg'},
			{data:'Asunto',name:'Asunto'},
			{data:'Observacion',name:'Observacion'},
			// {data:'Estado',name:'Estado'},
			// {data:'TipoPersona',name:'TipoPersona'},
			// {data:'Responsable',name:'Responsable'},
			// {data:'Empresa',name:'Empresa'},
		],
	    rowCallback: function( row, data, index ) {
	    	$('td:eq(0)', row).html('<a href="'+base_url+'/extranet/expediente/interno/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i>Revisar</a>');
			  switch(parseInt(data.estado)) {
				  case 0:
				    // $(row).addClass("table-info");
				    break;
				  case 1:
				    // $(row).addClass("table-success");
				    break;
				  case 2:
				    // $(row).addClass("table-danger");
				    break;
				  
				  default:
				  	break;
				    // code block
				}

		},
	    order: [[ 1, 'desc' ]]
	});
	$("#estado").on("change",function(){
		table.draw();
	});
});