$(document).ready(function(){
    $("#reporte").on("click",function(){
        // console.log("dsa");
        var estado = $("#estado").val();
        var servicio = $("#servicio").val();
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        // $(location).attr('href',base_url+"/extranet/expediente/reporte/pdf?estado="+estado+"&servicio="+servicio+"&fecha_ini="+fecha_ini+"&fecha_fin="+fecha_fin);
        window.open(base_url+"/extranet/expediente/reporte/pdf?estado="+estado+"&servicio="+servicio+"&fecha_ini="+fecha_ini+"&fecha_fin="+fecha_fin);
    });
	var table = $('#table-data').DataTable({
		// searching: false,
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/expediente?datatable=true',
			data: function (d) {
	            d.estado = $('#estado').val();
	            d.servicio = $('#servicio').val();
                d.fecha_ini = $('#fecha_ini').val();
                d.fecha_fin = $('#fecha_fin').val();
	        }
		},
		columns:[
			// {data:'Botones',name:'Botones'},
			{data:'SolicitudCodigo',name:'SolicitudCodigo'},
			{data:'CodigoExpediente',name:'CodigoExpediente'},
			{data:'Servicio',name:'Servicio'},
			{data:'Clase',name:'Clase'},
			{data:'Entidad',name:'Entidad'},
			{data:'FechaReg',name:'FechaReg'},
			// {data:'Asunto',name:'Asunto'},
			// {data:'Comentario',name:'Comentario'},
			{data:'Estado',name:'Estado'},
			// {data:'TipoPersona',name:'TipoPersona'},
			// {data:'Empresa',name:'Empresa'},
		],
	    rowCallback: function( row, data, index ) {
	    	// $('td:eq(0)', row).html('<a href="'+base_url+'/extranet/expediente/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i>Revisar</a>');
			  switch(parseInt(data.NumEstado)) {
				  case 0:
				    // $(row).addClass("table-info");
				    break;
				  case 1:
				    $(row).addClass("table-success");
				    break;
				  case 2:
				    $(row).addClass("table-danger");
				    break;
				  
				  default:
				  	break;
				    // code block
				}

		},
	    "orderable": false,
	    "targets": 'no-sort',
	});

    var start = moment().subtract(29, 'days');
    var end = moment();
    function cb(start, end) {
        $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
        $("#fecha_ini").val(start.format('YYYY-MM-DD'));
        $("#fecha_fin").val(end.format('YYYY-MM-DD'));

        table.draw();
    }
    moment.locale('es');
    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
           'Hoy': [moment(), moment()],
           'Ayer': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
           'Hace 7 Dias': [moment().subtract(6, 'days'), moment()],
           'Hace 30 Dias': [moment().subtract(29, 'days'), moment()],
           'Este Mes': [moment().startOf('month'), moment().endOf('month')],
           'Mes Anterior': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        locale: {
            "customRangeLabel": "Rango",
            "applyLabel": "Aplicar",
            "cancelLabel": "Cancelar",
        }
    }, cb);

    cb(start, end);
	$("#estado,#servicio").on("change",function(){
		table.draw();
	});
});