$(document).ready(function(){
	var editar = 0;
	var href = 0;
	var href_proceso = 0;
	var href_requisito = 0;

	$("#tipo_expediente").on("change",function(){
		var tipo = $("#tipo_expediente").val();
		if(tipo=="1"){
			$(".div-oficina").show();
			$("#unidad").prop("disabled",false);
		}else{
			$(".div-oficina").hide();
			$("#unidad").prop("disabled",true);
		}
	});

	var table = $('#table-data').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/configuracion/proceso?datatable=true'
		},
		columns:[
			{data:'Botones',name:'Botones'},
			{data:'RowId',name:'RowId'},
			{data:'TipoExpediente',name:'TipoExpediente'},
			{data:'UnidadOrganica',name:'UnidadOrganica'},
			{data:'Nombre',name:'Nombre'},
		],
	    rowCallback: function( row, data, index ) {
			var btn = '<a href="'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4 mt-1"><i class="fa fa fa-pencil-square-o"></i>Editar</a> '+
						'<a href="'+data.RowId+'" class="requisito btn btn-dark btn-sm col-xs-4 mt-1"><i class="fa fa fa-pencil-square-o"></i>Requisito</a> ';
			if(data.Tipo==1){
				btn+='<a href="'+data.RowId+'" class="proceso btn btn-dark btn-sm col-xs-4 mt-1"><i class="fa fa fa-pencil-square-o"></i>Proceso</a> ';
			}
	    	$('td:eq(0)', row).html(btn);
                                    
	    	$('td:eq(0)', row).delegate('.editar','click',function(e){ 
				href = $(this).attr('href');
				editar = 1;
				// alert(href);
				$("#title-datatable").text("Editar proceso");
				$.ajax({
                    type: "GET",
                    dataType: "json",
                    url:base_url+"/extranet/configuracion/proceso/"+href+"/edit",
                    success: function(data) {
						if(data.data.tipo==1){
							$(".div-oficina").show();
							$("#unidad").prop("disabled",false);
						}else{
							$(".div-oficina").hide();
							$("#unidad").prop("disabled",true);
						}
						$("#tipo_expediente").val(data.data.tipo);
						$("#unidad").val(data.data.id_oficina);
						$("#nombre").val(data.data.nombre);
                    },
                    error: function(result) {
                    }
                });
                $('#modal-datatable').modal('show');
				e.preventDefault();
			});
            $('td:eq(0)', row).delegate('.proceso','click',function(e){ 
				href = $(this).attr('href');
				// editar = 1;
                table_proceso.draw();
				// alert(href);
				// $("#title-datatable").text("Editar proceso");
                $('#modal-datatable-proceso').modal('show');
				e.preventDefault();
			});
			$('td:eq(0)', row).delegate('.requisito','click',function(e){ 
				href = $(this).attr('href');
				// editar = 1;
                table_requisito.draw();
				// alert(href);
				// $("#title-datatable").text("Editar requisito");
                $('#modal-datatable-requisito').modal('show');
				e.preventDefault();
			});

		},
	    order: [[ 1, 'asc' ]]
	});

    var table_proceso = $('#table-data-proceso').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/configuracion/proceso/detalle/oficina?datatable=true',
            data: function (d) {
	            d.proceso = href;
	        }
		},
		columns:[
			{data:'Botones',name:'Botones'},
			{data:'Orden',name:'Orden'},
			{data:'Oficina',name:'Oficina'},
		],
	    rowCallback: function( row, data, index ) {
            $('td:eq(0)', row).html('<a href="'+data.RowId+'" class="eliminar btn btn-danger btn-sm col-xs-4"><i class="fas fa-times"></i></a> '
                                    // '<a href="'+data.RowId+'" class="proceso btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o"></i>Proceso</a> '
                                    );
            $('td:eq(0)', row).delegate('.eliminar','click',function(e){ 
                href_proceso = $(this).attr('href');
                $.confirm({
                    title: '',
                    content: '¿Esta seguro de borrar la oficina?',
                    type: 'orange',
                    theme: 'modern',
                    // closeIcon: true,
                    icon: 'fas fa-question',
                    buttons: {
                        confirm: {
                            text:"Aceptar",
                            btnClass: 'btn-green',
                            action: function(){
                                $('.content').loader('show');
                                $.ajax({
                                    type: "DELETE",
                                    dataType: "json",
                                    url: base_url+"/extranet/configuracion/proceso/detalle/oficina/"+href_proceso,
                                    // data:data,
                                    success:function(data){
                                        $('.content').loader('hide');
                                          if(data.status == true){
                                            $.confirm({
                                                title: 'Satisfactorio',
                                                content: data['message'],
                                                type: 'green',
                                                theme: 'modern',
                                                // closeIcon: true,
                                                icon: 'fas fa-check',
                                                buttons: {
                                                  confirm: {
                                                      text:"Aceptar",
                                                      btnClass: 'btn-green',
                                                      action: function(){
                                                        //   location.reload();
                                                        table_proceso.draw();
                                                      }
                                                  }
                                                }
                                            });
                    
                                        }else{
                                            $.confirm({
                                                title: 'Error!',
                                                content: data['message'],
                                                type: 'orange',
                                                theme: 'modern',
                                                closeIcon: true,
                                                icon: 'fas fa-exclamation-triangle',
                                                buttons: {
                                                  confirm: {
                                                      text:"Intentar de nuevo",
                                                      btnClass: 'btn-green',
                                                      action: function(){
                                                          // table.draw();
                                                      }
                                                  }
                                                }
                                            });
                                        }
                                        // $('#modal-datatable-derivar').modal('hide');
                                    },
                                    error:function(result){
                    
                                    }
                                });
                            }
                        },
                        cancel:{
                            text:"Salir",
                            action:function(){
                               
                            }
                        }
                    }
                });
                e.preventDefault();
            });
		},
	    order: [[ 1, 'asc' ]]
	});
	var table_requisito = $('#table-data-requisito').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:base_url+'/js/spanish.json'
	    },
		ajax:{
			url:base_url+'/extranet/configuracion/proceso/detalle/requisito?datatable=true',
            data: function (d) {
	            d.proceso = href;
	        }
		},
		columns:[
			{data:'Botones',name:'Botones'},
			{data:'Orden',name:'Orden'},
			{data:'Requisito',name:'Requisito'},
			{data:'Tipo',name:'Tipo'},
		],
	    rowCallback: function( row, data, index ) {
            $('td:eq(0)', row).html('<a href="'+data.RowId+'" class="eliminar btn btn-danger btn-sm col-xs-4"><i class="fas fa-times"></i></a> '
                                    // '<a href="'+data.RowId+'" class="requisito btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o"></i>requisito</a> '
                                    );
            $('td:eq(0)', row).delegate('.eliminar','click',function(e){ 
                href_requisito = $(this).attr('href');
                $.confirm({
                    title: '',
                    content: '¿Esta seguro de borrar el requisito?',
                    type: 'orange',
                    theme: 'modern',
                    // closeIcon: true,
                    icon: 'fas fa-question',
                    buttons: {
                        confirm: {
                            text:"Aceptar",
                            btnClass: 'btn-green',
                            action: function(){
                                $('.content').loader('show');
                                $.ajax({
                                    type: "DELETE",
                                    dataType: "json",
                                    url: base_url+"/extranet/configuracion/proceso/detalle/requisito/"+href_requisito,
                                    // data:data,
                                    success:function(data){
                                        $('.content').loader('hide');
                                          if(data.status == true){
                                            $.confirm({
                                                title: 'Satisfactorio',
                                                content: data['message'],
                                                type: 'green',
                                                theme: 'modern',
                                                // closeIcon: true,
                                                icon: 'fas fa-check',
                                                buttons: {
                                                  confirm: {
                                                      text:"Aceptar",
                                                      btnClass: 'btn-green',
                                                      action: function(){
                                                        //   location.reload();
                                                        table_requisito.draw();
                                                      }
                                                  }
                                                }
                                            });
                    
                                        }else{
                                            $.confirm({
                                                title: 'Error!',
                                                content: data['message'],
                                                type: 'orange',
                                                theme: 'modern',
                                                closeIcon: true,
                                                icon: 'fas fa-exclamation-triangle',
                                                buttons: {
                                                  confirm: {
                                                      text:"Intentar de nuevo",
                                                      btnClass: 'btn-green',
                                                      action: function(){
                                                          // table.draw();
                                                      }
                                                  }
                                                }
                                            });
                                        }
                                        // $('#modal-datatable-derivar').modal('hide');
                                    },
                                    error:function(result){
                    
                                    }
                                });
                            }
                        },
                        cancel:{
                            text:"Salir",
                            action:function(){
                               
                            }
                        }
                    }
                });
                e.preventDefault();
            });
		},
	    order: [[ 1, 'asc' ]]
	});

	var validator = $("#formulary").validate({
        rules:{
            'tipo_expediente':{
                required:true
            },           
            'oficina':{
                required:true
            } ,          
            'nombre':{
                required:true
            }           
        },
        messages:{
            'tipo_expediente':{
                required:"Este campo es requerido."
            },
            'oficina':{
                required:"Este campo es requerido."
            },
            'nombre':{
                required:"Este campo es requerido."
            }
        }
    });
	var validator_proceso = $("#formulary-proceso").validate({
        rules:{
            'orden':{
                required:true,
				number:true
            },           
            'oficina':{
                required:true
            }           
        },
        messages:{
            'orden':{
                required:"Este campo es requerido.",
				number:"Solo se permite números."
            },
            'oficina':{
                required:"Este campo es requerido."
            }
        }
    });
	var validator_requisito = $("#formulary-requisito").validate({
        rules:{
            'orden':{
                required:true,
				number:true
            },           
            'requisito':{
                required:true
            },           
            'tipo':{
                required:true
            }           
        },
        messages:{
            'orden':{
                required:"Este campo es requerido.",
				number:"Solo se permite números."
            },
            'requisito':{
                required:"Este campo es requerido."
            },
            'tipo':{
                required:"Este campo es requerido."
            }
        }
    });

	$("#nuevo").on("click",function(){
    	editar = 0;
    	$("#title-datatable").text("Nuevo proceso");
		$('#modal-datatable').modal('show');
		$("#formulary")[0].reset();
	});

    $("#guardar").on("click",function(){
    	var validar = validator.form();
    	if(validar == true){
    		data = $("#formulary").serialize();
    		$('.content').loader('show');
    		if(editar==1){
			    $.ajax({
			        type: "PUT",
			        dataType: "json",
			        url: base_url+"/extranet/configuracion/proceso/"+href,
			        data:data,
			        success:function(data){
			          // console.log(data);
                        $('.content').loader('hide');
			          	if(data.status == true){
				              // var objeto = JSON.parse(data['message']);
							table.draw();
							$.confirm({
								title: 'Satisfactorio',
								content: data['message'],
								type: 'green',
								theme: 'modern',
								// closeIcon: true,
								icon: 'fas fa-check',
								buttons: {
								  confirm: {
								      text:"Aceptar",
								      btnClass: 'btn-green',
								      action: function(){
								      }
								  }
								}
							});

				        }else{
				            $.confirm({
								title: 'Error!',
								content: data['message'],
								type: 'orange',
								theme: 'modern',
								closeIcon: true,
								icon: 'fas fa-exclamation-triangle',
								buttons: {
								  confirm: {
								      text:"Intentar de nuevo",
								      btnClass: 'btn-green',
								      action: function(){
								          table.draw();
								      }
								  },
								  cancel:{
								      text:"Salir",
								      action:function(){
								         
								      }
								  }
				                }
				            });
				        }
		                // table.draw();
		                $('#modal-datatable').modal('hide');
			        },
			        error:function(result){

			        }
			    });
    		}else{
    			$.ajax({
			        type: "POST",
			        dataType: "json",
			        url: base_url+"/extranet/configuracion/proceso",
			        data:data,
			        success:function(data){
			          // console.log(data);
                        $('.content').loader('hide');
			          	if(data.status == true){
				              // var objeto = JSON.parse(data['message']);
							table.draw();
							$.confirm({
								title: 'Satisfactorio',
								content: data['message'],
								type: 'green',
								theme: 'modern',
								// closeIcon: true,
								icon: 'fas fa-check',
								buttons: {
								  confirm: {
								      text:"Aceptar",
								      btnClass: 'btn-green',
								      action: function(){
								      }
								  }
								}
							});

				        }else{
				            $.confirm({
								title: 'Error!',
								content: data['message'],
								type: 'orange',
								theme: 'modern',
								closeIcon: true,
								icon: 'fas fa-exclamation-triangle',
								buttons: {
								  confirm: {
								      text:"Intentar de nuevo",
								      btnClass: 'btn-green',
								      action: function(){
								          table.draw();
								      }
								  },
								  cancel:{
								      text:"Salir",
								      action:function(){
								         
								      }
								  }
				                }
				            });
				        }
		                // table.draw();
		                $('#modal-datatable').modal('hide');
			        },
			        error:function(result){

			        }
			    });
    		}
    	}
    })

	$("#guardar-proceso").on("click",function(){
    	var validar_proceso = validator_proceso.form();
    	if(validar_proceso == true){
    		data = $("#formulary-proceso").serialize();
    		$('.content').loader('show');
    		
			$.ajax({
				type: "POST",
				dataType: "json",
				url: base_url+"/extranet/configuracion/proceso/detalle/oficina/"+href,
				data:data,
				success:function(data){
					// console.log(data);
					$('.content').loader('hide');
					if(data.status == true){
							// var objeto = JSON.parse(data['message']);
						table_proceso.draw();
						$.confirm({
							title: 'Satisfactorio',
							content: data['message'],
							type: 'green',
							theme: 'modern',
							// closeIcon: true,
							icon: 'fas fa-check',
							buttons: {
								confirm: {
									text:"Aceptar",
									btnClass: 'btn-green',
									action: function(){
									}
								}
							}
						});
						$("#proceso-orden").val("");
						$("#proceso-orden").removeClass("is-valid is-invalid");
						$("#proceso-oficina").val("");
						$("#proceso-oficina").removeClass("is-valid is-invalid");

					}else{
						$.confirm({
							title: 'Error!',
							content: data['message'],
							type: 'orange',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-exclamation-triangle',
							buttons: {
								confirm: {
									text:"Intentar de nuevo",
									btnClass: 'btn-green',
									action: function(){
										table_proceso.draw();
									}
								},
								cancel:{
									text:"Salir",
									action:function(){
										
									}
								}
							}
						});
					}
					// table.draw();
					// $('#modal-datatable').modal('hide');
				},
				error:function(result){

				}
			});
    	}
    })
	$("#guardar-requisito").on("click",function(){
    	var validar_requisito = validator_requisito.form();
    	if(validar_requisito == true){
    		data = $("#formulary-requisito").serialize();
    		$('.content').loader('show');
    		
			$.ajax({
				type: "POST",
				dataType: "json",
				url: base_url+"/extranet/configuracion/proceso/detalle/requisito/"+href,
				data:data,
				success:function(data){
					// console.log(data);
					$('.content').loader('hide');
					if(data.status == true){
							// var objeto = JSON.parse(data['message']);
						table_requisito.draw();
						$.confirm({
							title: 'Satisfactorio',
							content: data['message'],
							type: 'green',
							theme: 'modern',
							// closeIcon: true,
							icon: 'fas fa-check',
							buttons: {
								confirm: {
									text:"Aceptar",
									btnClass: 'btn-green',
									action: function(){
									}
								}
							}
						});
						$("#requisito-orden").val("");
						$("#requisito-orden").removeClass("is-valid is-invalid");
						$("#requisito-requisito").val("");
						$("#requisito-requisito").removeClass("is-valid is-invalid");
						$("#requisito-tipo").val("");
						$("#requisito-tipo").removeClass("is-valid is-invalid");

					}else{
						$.confirm({
							title: 'Error!',
							content: data['message'],
							type: 'orange',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-exclamation-triangle',
							buttons: {
								confirm: {
									text:"Intentar de nuevo",
									btnClass: 'btn-green',
									action: function(){
										table_requisito.draw();
									}
								},
								cancel:{
									text:"Salir",
									action:function(){
										
									}
								}
							}
						});
					}
					// table.draw();
					// $('#modal-datatable').modal('hide');
				},
				error:function(result){

				}
			});
    	}
    })

    // $("#tipo_f").on("change",function(){
    // 	table.draw();
    // })
});