$(document).ready(function(){

	var table = $('#table-data').DataTable({
		processing:true,
		serverSide:true,
		language: {
	        url:'/js/spanish.json'
	    },
		ajax:{
			url:'/entidad/tramite?datatable=true',
			data: function (d) {
	            d.estado = $('#estado').val();
	        }
		},
		columns:[
			{data:'Botones',name:'Botones'},
			{data:'SolicitudCodigo',name:'SolicitudCodigo'},
			{data:'CodigoExpediente',name:'CodigoExpediente'},
			{data:'NumeroDocumento',name:'NumeroDocumento'},
			{data:'FechaReg',name:'FechaReg'},
			{data:'Asunto',name:'Asunto'},
			{data:'Comentario',name:'Comentario'},
			{data:'Estado',name:'Estado'},
		],
	    rowCallback: function( row, data, index ) {
	    	$('td:eq(0)', row).html('<a href="/entidad/tramite/expediente/'+data.RowId+'" class="editar btn btn-dark btn-sm col-xs-4"><i class="fa fa fa-pencil-square-o" aria-hidden="true"></i>Revisar</a>');
			  switch(parseInt(data.EstadoNumero)) {
				  case 0:
				    // $(row).addClass("table-info");
				    break;
				  case 1:
				    $(row).addClass("table-success");
				    break;
				  case 2:
				    $(row).addClass("table-danger");
				    break;
				  
				  default:
				  	break;
				    // code block
				}

		},
        orderable: false
	});
	$("#estado").on("change",function(){
		table.draw();
	});
});