$(document).ready(function(){
    var empresa = false;
    var idempresa = 0;

	$("#tipo_persona").on("change",function(){
		tipo_persona = $("#tipo_persona").val();
		if(tipo_persona==1){
			$("#empresa").show('slow');
			$(".empresa").prop('disabled',false);
		}else{
			$("#empresa").hide('slow');
			$(".empresa").prop('disabled',true);

		}
			$(".empresa").val('');
	});

    $("#ruc").focusout(function(){
        var ruc = $("#ruc").val();

        if(ruc!=""){
            // load.open();
            $('.content').loader('show');
            $.ajax({
                type: "GET",
                dataType: "json",
                url:"/entidad/empresa/search/"+ruc,
                success: function(data) {
                    // console.log(data);
                    $('.content').loader('hide');
                    if(data.status==true){
                        empresa = true;
                        idempresa = data.datos.id;
                        $("#razon_social").val(data.datos.empresa);
                        $("#direccion_empresa").val(data.datos.direccion);
                    }else{
                        $("#razon_social").val("");
                        $("#direccion_empresa").val("");
                        empresa = false;
                        idempresa = 0;
                    }
                    // load.close();
                },
                error: function(result) {
                }
            });
        }else{
            empresa = false;
            idempresa = 0;
        }

        $("#datos_personales").show("slow");
    })


	$("#tipo_documento").select2({
        allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un Tipo de Documento",
        ajax: {
            url:"/select2/tipo_documento",
            dataType: 'json',
            data: function (params) {
                return {
                    q: params.term
                };
            },
            processResults: function (data) {
                return {
                    results: data.items
                };
            },

          cache: true
        },
        minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#tipo_documento").removeClass('is-invalid')
        $("#documento").rules("remove");
        // console.log(e.params.data.numeros);
        if(e.params.data.numeros==1){
            $("#documento").rules("add",{
                number: true,
                messages: {
                    number: "Solo se permiten numeros."
                }
            });
        }else{

        }
        $("#documento").rules("add",{
            required: true,
            minlength: e.params.data.min,
            maxlength: e.params.data.max,
            messages: {
                required: "Este campo es requerido.",
                minlength: "Minimo como "+e.params.data.min+" caracteres.",
                maxlength: "Maximo como "+e.params.data.max+" caracteres."
            }
        });
    });


	$("#provincia").prop('disabled', true);
    $("#distrito").prop('disabled', true);

	var departamento = 0;
    var provincia = 0;
    $("#departamento").select2({
        allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un departamento",
        ajax: {
            url:"/select2departamento/",
            dataType: 'json',
            // delay: 250,
            data: function (params) {
                return {
                    q: params.term 
                };
            },
            processResults: function (data) {
                return {
                    results: data.items
                };
            },

            cache: true
        },
        minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#departamento").removeClass('is-invalid')
        $("#provincia").prop('disabled', false);

        departamento = e.params.data.id;
        $("#provincia").val('').trigger('change');
        $("#distrito").val('').trigger('change');

        $("#distrito").prop('disabled', true);
    });

    $("#provincia").select2({
      allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un provincia",
      ajax: {
        url:"/select2provincia/",
        dataType: 'json',
        // delay: 250,
        data: function (params) {
            return {
                q: params.term,
                departamento:departamento 
            };
        },
        processResults: function (data) {
            return {
                results: data.items
            };
        },

        cache: true
    },
    minimumInputLength: -1
    }).on("select2:select", function (e) {
    	$("#provincia").removeClass('is-invalid')
        $("#distrito").prop('disabled', false);
        provincia = e.params.data.id;
        $("#distrito").val('').trigger('change');
        console.log(e.params.data);
    });

    $("#distrito").select2({
      allowClear: true,
        theme: 'bootstrap4',
        language: "es",
        placeholder: "Seleccione un distrito",
      ajax: {
        url:"/select2distrito",
        dataType: 'json',
        // delay: 250,
        data: function (params) {
            return {
                q: params.term,
                departamento:departamento, 
                provincia:provincia 
            };
        },
        processResults: function (data) {
            return {
                results: data.items
            };
        },

        cache: true
    },
    minimumInputLength: -1
    })
    .on("select2:select", function (e) {
    	$("#distrito").removeClass('is-invalid')
        // $("#distrito").prop('disabled', false);
        console.log(e.params.data);
    });

	var validator = $("#formulary").validate({
        rules:{
        	'tipo_persona':{
                required:true
            },
            'ruc':{
                required:true,
                number:true,
                minlength:11,
                maxlength:11
            },
            'razon_social':{
                required:true
            },
            'razon_social':{
                required:true
            },
            'direccion_empresa':{
                required:true
            },
            'tipo_documento':{
                required:true
            },
            'documento':{
                required:true
            },
            'paterno':{
                required:true
            },
            'materno':{
                required:true
            },
            'nombres':{
                required:true
            },
            'departamento':{
                required:true
            },
            'provincia':{
                required:true
            },
            'distrito':{
                required:true
            },
            'direccion':{
                required:true
            },
            'telefono':{
                required:true,
                number:true,
                minlength:9,
                maxlength:9
            },
            'email':{
                required:true,
                email:true
            },
            'email_confirm':{
                required:true,
                email:true,
                equalTo:"#email"
            },
            'password':{
                required:true,
            },
            'password_confirm':{
                required:true,
                equalTo:"#password"
            },
            'terminos':{
                required:true
            }
            
        },
        messages:{
        	'tipo_persona':{
                required:"Este campo es requerido."
            },
            'ruc':{
                required:"Este campo es requerido.",
                number:"Solo se permiten numeros.",
                minlength:"Minimo 11 caracteres.",
                maxlength:"Maximo 11 caracteres."
            },
            'razon_social':{
                required:"Este campo es requerido."
            },
            'razon_social':{
                required:"Este campo es requerido."
            },
            'direccion_empresa':{
                required:"Este campo es requerido."
            },
            'tipo_documento':{
                required:"Este campo es requerido."
            },
            'documento':{
                required:"Este campo es requerido."
            },
            'paterno':{
                required:"Este campo es requerido."
            },
            'materno':{
                required:"Este campo es requerido."
            },
            'nombres':{
                required:"Este campo es requerido."
            },
            'departamento':{
                required:"Este campo es requerido."
            },
            'provincia':{
                required:"Este campo es requerido."
            },
            'distrito':{
                required:"Este campo es requerido."
            },
            'direccion':{
                required:"Este campo es requerido."
            },
            'telefono':{
                required:"Este campo es requerido.",
                number: "Solo se permiten numeros.",
                minlength: "Minimo como 9 caracteres.",
                maxlength: "Maximo como 9 caracteres."
            },
            'email':{
                required:"Este campo es requerido.",
                email:"Formato invalido"
            },
            'email_confirm':{
                required:"Este campo es requerido.",
                email:"Formato invalido",
                equalTo:"El Correo Electronico no coincide con el anterior."
            },
            'password':{
                required:"Este campo es requerido.",
            },
            'password_confirm':{
                required:"Este campo es requerido.",
                equalTo:"La contraseña no coincide con el anterio."
            },
            'terminos':{
                required:"Este campo es requerido."
            }
        }
    });

    $("#guardar").on("click",function(){
    	var validar = validator.form();
    	if(validar == true){
    		data = $("#formulary").serialize()+"&empresa="+empresa+"&idempresa="+idempresa;
    		// var data = new FormData($("#formulary")[0]);
    		// load.open();
            $('.content').loader('show');
			$.ajax({
		        type: "POST",
		        dataType: "json",
		        url: "/entidad/register",
		        data:data,
		        success:function(data){
		          // console.log(data);
		            $('.content').loader('hide');
		          	if(data.status == true){
						$.confirm({
							title: 'Exito!',
							content: data['message'],
							type: 'green',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-check',
							buttons: {
							  confirm: {
							      text:"Aceptar",
							      btnClass: 'btn-green',
							      action: function(){
                                    $(location).attr('href', '/entidad/login');
							      }
							  }
							}
						});
			        }else{
			            $.confirm({
							title: 'Aviso!',
							content: data['message'],
							type: 'orange',
							theme: 'modern',
							closeIcon: true,
							icon: 'fas fa-exclamation-triangle',
							buttons: {
							  confirm: {
							      text:"Intentar de nuevo",
							      btnClass: 'btn-green',
							      action: function(){
							      }
							  },
							  cancel:{
							      text:"Salir",
							      action:function(){
							         
							      }
							  }
			                }
			            });
			        }
	                // table.draw();
	                // $('#modal-datatable').modal('hide');
		        },
		        error:function(result){

		        }
		    });
    	}
    })
});