<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ubigeo', function (Blueprint $table) {
            $table->increments('id');
            $table->char('departamento', 2)->nullable()->default(null)->collation('latin1_swedish_ci');
            $table->char('provincia', 2)->nullable()->default(null)->collation('latin1_swedish_ci');
            $table->char('distrito', 2)->nullable()->default(null)->collation('latin1_swedish_ci');
            $table->string('nombre', 100)->nullable()->default(null)->collation('latin1_swedish_ci');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ubigeo');
    }
};
