<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tramite', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('id_expediente')->unsigned();
            $table->tinyInteger('estado')->nullable()->default(0)->comment('0 = pendiente, 1 = recibido, 2 = derivado, 3 = rechazado, 4 = finalizado, 5 = Archivado, 6 = observado');
            $table->text('observacion')->nullable()->collation('latin1_swedish_ci');
            $table->dateTime('fecha_estado')->nullable();
            $table->bigInteger('id_users')->unsigned()->nullable();
            $table->integer('id_oficina')->unsigned();
            $table->integer('id_oficina_destino')->unsigned()->nullable();
            $table->timestamps();
            $table->tinyInteger('copia')->nullable()->default(0)->comment('0 = no, 1 = sí');
            $table->integer('id_tramite')->nullable()->unsigned();
            $table->tinyInteger('actual')->nullable()->default(1)->comment('0 = no, 1 = sí');
            $table->integer('id_accion')->nullable()->unsigned();
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->index('id_expediente', 'fk_tramite_expediente1_idx');
            $table->index('id_oficina', 'fk_tramite_oficina1_idx');
            $table->index('id_oficina_destino', 'fk_tramite_oficina2_idx');
            $table->index('id_users', 'fk_tramite_users1_idx');
            $table->index('id_tramite', 'fk_tramite_tramite1_idx');
            $table->index('id_accion', 'fk_tramite_accion1_idx');

            $table->foreign('id_accion')->references('id')->on('accion')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_expediente')->references('id')->on('expediente')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_oficina')->references('id')->on('oficina')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_oficina_destino')->references('id')->on('oficina')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_tramite')->references('id')->on('tramite')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_users')->references('id')->on('users')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tramite');
    }
};
