<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proceso_requisito', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('orden')->nullable();
            $table->integer('id_proceso')->unsigned();
            $table->integer('id_requisito')->unsigned();
            $table->tinyInteger('tipo')->comment('1 = empiezo, 2 = en tramite, 3 = fisico');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->index('id_proceso', 'fk_proceso_requisito_proceso1_idx');
            $table->index('id_requisito', 'fk_proceso_requisito_requisito1_idx');

            $table->foreign('id_proceso')->references('id')->on('proceso')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_requisito')->references('id')->on('requisito')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proceso_requisito');
    }
};
