<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proceso_detalle', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('orden')->nullable();
            $table->string('plazo', 45)->nullable()->collation('latin1_swedish_ci');
            $table->integer('id_proceso')->unsigned();
            $table->integer('id_oficina')->unsigned();
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->index('id_proceso', 'fk_proceso_detalle_proceso1_idx');
            $table->index('id_oficina', 'fk_proceso_detalle_oficina1_idx');

            $table->foreign('id_oficina')->references('id')->on('oficina')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_proceso')->references('id')->on('proceso')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proceso_detalle');
    }
};
