<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('proceso', function (Blueprint $table) {
            $table->increments('id');
            $table->text('nombre')->nullable()->collation('latin1_swedish_ci');
            $table->tinyInteger('tipo')->nullable()->comment('0 = interno, 1 = tupa, 2 = no tupa, 3 = otro');
            $table->integer('plazo')->nullable();
            $table->integer('id_oficina')->nullable()->unsigned();
            $table->string('abrev', 45)->nullable()->collation('latin1_swedish_ci');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->index('id_oficina', 'fk_proceso_oficina1_idx');
            $table->foreign('id_oficina')->references('id')->on('oficina')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('proceso');
    }
};
