<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('periodo', function (Blueprint $table) {
            $table->increments('id');
            $table->char('nombre', 4)->nullable()->collation('latin1_swedish_ci');
            $table->char('abrev', 2)->nullable()->collation('latin1_swedish_ci');
            $table->tinyInteger('estado')->nullable()->default(0);
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('periodo');
    }
};
