<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('firma_parametros', function (Blueprint $table) {
            $table->increments('id');
            $table->string('signatureFormat', 50)->collation('utf8mb4_general_ci');
            $table->string('signatureLevel', 10)->collation('utf8mb4_general_ci');
            $table->string('signaturePackaging', 50)->collation('utf8mb4_general_ci');
            $table->string('documentToSign', 255)->collation('utf8mb4_general_ci');
            $table->string('certificateFilter', 255)->collation('utf8mb4_general_ci');
            $table->string('webTsa', 255)->nullable()->collation('utf8mb4_general_ci');
            $table->string('userTsa', 255)->nullable()->collation('utf8mb4_general_ci');
            $table->string('passwordTsa', 255)->nullable()->collation('utf8mb4_general_ci');
            $table->string('theme', 50)->collation('utf8mb4_general_ci');
            $table->tinyInteger('visiblePosition');
            $table->string('contactInfo', 255)->nullable()->collation('utf8mb4_general_ci');
            $table->string('signatureReason', 255)->collation('utf8mb4_general_ci');
            $table->tinyInteger('bachtOperation');
            $table->tinyInteger('oneByOne');
            $table->integer('signatureStyle');
            $table->string('imageToStamp', 255)->collation('utf8mb4_general_ci');
            $table->integer('stampTextSize');
            $table->integer('stampWordWrap');
            $table->string('role', 255)->collation('utf8mb4_general_ci');
            $table->integer('stampPage');
            $table->integer('positionx');
            $table->integer('positiony');
            $table->string('uploadDocumentSigned', 255)->collation('utf8mb4_general_ci');
            $table->tinyInteger('certificationSignature');
            $table->string('token', 250)->collation('utf8mb4_general_ci');
            $table->string('param_token', 100)->nullable()->collation('utf8mb4_general_ci');
            $table->string('fir_ide', 50)->nullable()->collation('utf8mb4_general_ci');
            $table->engine = 'InnoDB';
            $table->collation = 'utf8mb4_general_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('firma_parametros');
    }
};
