<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('firma', function (Blueprint $table) {
            $table->increments('fir_ide');
            $table->integer('fir_user_ide')->nullable()->unsigned();
            $table->string('fir_nombre', 50)->nullable()->collation('utf8mb4_general_ci');
            $table->string('fir_file_name', 100)->nullable()->collation('utf8mb4_general_ci');
            $table->string('fir_file_path', 200)->nullable()->collation('utf8mb4_general_ci');
            $table->string('fir_formato', 50)->nullable()->collation('utf8mb4_general_ci');
            $table->integer('fir_sign')->nullable()->default(0);
            $table->dateTime('fir_date_sign')->nullable();
            $table->timestamp('fir_date_created')->nullable()->useCurrent();
            $table->timestamp('fir_date_updated')->nullable()->useCurrent()->onUpdate(\Illuminate\Support\Facades\DB::raw('CURRENT_TIMESTAMP'));
            $table->engine = 'InnoDB';
            $table->collation = 'utf8mb4_general_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('firma');
    }
};
