<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expediente_requisito', function (Blueprint $table) {
            $table->increments('id');
            $table->text('enlace')->nullable()->collation('latin1_swedish_ci');
            $table->integer('id_requisito')->nullable()->unsigned();
            $table->integer('id_expediente')->unsigned();
            $table->tinyInteger('tipo')->nullable()->comment('1=empiezo, 2=en tramite, 3=fisico, 4=requerido');
            $table->tinyInteger('estado')->nullable()->default(0)->comment('0=pendiente, 1=adjuntado');
            $table->tinyInteger('observado')->nullable()->default(0);
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->index('id_requisito', 'fk_expediente_requisito_requisito1_idx');
            $table->index('id_expediente', 'fk_expediente_requisito_expediente1_idx');

            $table->foreign('id_expediente')->references('id')->on('expediente')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_requisito')->references('id')->on('requisito')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expediente_requisito');
    }
};
