<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('expediente_adjunto', function (Blueprint $table) {
            $table->integer('id_expediente')->unsigned();
            $table->integer('id_adjunto')->unsigned();
            $table->tinyInteger('visible_usuario')->nullable()->default(0)->comment('0=no, 1=sí');

            $table->index('id_expediente', 'fk_expediente_adjunto_expediente1_idx');
            $table->index('id_adjunto', 'fk_expediente_adjunto_adjunto1_idx');

            $table->foreign('id_adjunto')->references('id')->on('adjunto')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_expediente')->references('id')->on('expediente')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('expediente_adjunto');
    }
};
