<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('entidad', function (Blueprint $table) {
            $table->increments('id');
            $table->string('documento', 45)->collation('latin1_swedish_ci');
            $table->string('paterno', 45)->nullable()->collation('latin1_swedish_ci');
            $table->string('materno', 45)->nullable()->collation('latin1_swedish_ci');
            $table->string('nombres', 100)->nullable()->collation('latin1_swedish_ci');
            $table->string('telefono', 9)->nullable()->collation('latin1_swedish_ci');
            $table->string('email', 100)->nullable()->collation('latin1_swedish_ci');
            $table->string('direccion', 100)->nullable()->collation('latin1_swedish_ci');
            $table->integer('id_tipo_documento')->unsigned();
            $table->integer('id_ubigeo')->nullable()->unsigned();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->tinyInteger('extranjero')->nullable()->default(0)->comment('0 = no, 1 = sí');
            $table->string('pais', 100)->nullable()->collation('latin1_swedish_ci');
            $table->tinyInteger('tipo')->nullable()->default(0)->comment('0= Público, 1= Institución');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';

            $table->unique('documento');
            $table->foreign('id_tipo_documento')->references('id')->on('tipo_documento')->onUpdate('no action')->onDelete('no action');
            $table->foreign('id_ubigeo')->references('id')->on('ubigeo')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('entidad');
    }
};
