<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('empresa', function (Blueprint $table) {
            $table->increments('id');
            $table->char('ruc', 11)->nullable()->unique()->collation('latin1_swedish_ci');
            $table->string('razon_social', 100)->nullable()->collation('latin1_swedish_ci');
            $table->string('direccion', 100)->nullable()->collation('latin1_swedish_ci');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('empresa');
    }
};
