<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('configuracion', function (Blueprint $table) {
            $table->increments('id');
            $table->time('hora_ini')->nullable();
            $table->time('hora_fin')->nullable();
            $table->string('dias', 45)->nullable()->collation('latin1_swedish_ci');
            $table->tinyInteger('estado')->nullable()->default(1);
            $table->text('nota')->nullable()->collation('latin1_swedish_ci');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('configuracion');
    }
};
