<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('adjunto', function (Blueprint $table) {
            $table->increments('id');
            $table->text('nombre')->nullable()->collation('latin1_swedish_ci');
            $table->text('enlace')->nullable()->collation('latin1_swedish_ci');
            $table->integer('id_oficina')->unsigned();
            $table->foreign('id_oficina')->references('id')->on('oficina')->onUpdate('cascade')->onDelete('restrict');
            $table->index('id_oficina', 'fk_adjunto_oficina1_idx');
            $table->engine = 'InnoDB';
            $table->collation = 'latin1_swedish_ci';
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('adjunto');
    }
};
