<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasRoles as HasRoles;


class User extends Authenticatable
{
    use Notifiable;
    use HasRoles;
    protected $guard_name =['super_admin','admin','funcionario','apoyo_funcionario','validacion','apoyo_validacion'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function oficina(){
        return $this->hasOne('App\Models\Oficina', 'id','id_oficina');
    }

    public function rol(){
        return $this->hasOneThrough(
            'App\Models\Roles',
            'App\Models\ModelRoles',
            'model_id',
            'id',
            'id',
            'role_id'
         );

        // return $this->belongsToMany('App\Empresa','usuario_empresa','id_users','id_empresa');
    }
}
