<?php

namespace App\Http\Middleware;
use Illuminate\Support\Facades\Auth;
use Mockery\Matcher\Closure;

class MWActivation
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $user = Auth::user();
        if($user->status==0){
            Auth::logout();
            return redirect('/entidad/login')->with('data','Revise su cuenta de correo electronico para validar la cuenta.');
        }
        return $next($request);
    }
}
