<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Str;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Expediente;
use App\Models\Entidad;
use App\Models\ExpedienteRequisito;
use App\Models\Proceso;
use App\Models\Empresa;
use App\Mail\Mensaje;
// use App\Mail\Seguimiento;
use Illuminate\Support\Facades\Mail;

class IndexController extends Controller
{
    public function index()  {
        
    }

    public function email(){
        // return view("web.validacion");
        $mensaje["responsable"] = "47520697|ROMERO CONDORI JAVIER ELARD";
        $mensaje["codigo"] = "S-000013-21";
        $mensaje["password"] = "1068";
        $email = Mail::to('elard.12.03@gmail.com')->send(new Mensaje($mensaje));
        // dd($email);
        return "mensaje enviado";
    }
    public function validacion(){
        return view("web.validacion");
    }
    public function extranjero(){
        return view("web.extranjero");
    }

    public function formulario(Request $request){
        $response = $this->habilitado();
        //$response = $this->habilitado();
        //dd($response);
        return view("web.formulario",$response);
    }
    
    public function store(Request $request){
        // var_dump($request->tipo_expediente);
        // dd($request);
        DB::beginTransaction();
        try {
            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("solicitud_numero")
                ->where("id_periodo",$periodo->id)
                ->orderBy("solicitud_numero","desc")
                ->first();
            $numero = 1;

            if($query){
                $numero = (int)$query->solicitud_numero + 1;
            }

            $codigo= "S-".$periodo->abrev."-".str_pad($numero, 6, "0", STR_PAD_LEFT);

            $persona = DB::table("entidad")
                        ->where("documento",$request->documento)
                        ->first();
            $empresa = NULL;

            if($request->tipo_persona == '1'){
                $query_empresa = DB::table("empresa")
                        ->where("ruc",$request->ruc)
                        ->first();
                if($query_empresa){
                    $empresa = $query_empresa->id;
                }else{
                    $new_empresa = new Empresa;
                    $new_empresa->ruc = $request->ruc;
                    $new_empresa->razon_social = $request->razon_social;
                    $new_empresa->direccion = $request->direccion_empresa;
                    $new_empresa->save();
                    $empresa = $new_empresa->id;
                }
            }

            if($persona){
                $entidad = Entidad::find($persona->id);
                $entidad->telefono = $request->telefono;
                $entidad->email = $request->email;
                $entidad->direccion = $request->direccion;
                // if(isset($request->distrito)){
                $entidad->id_ubigeo = $request->distrito;
                // }
                // if(isset($request->pais)){
                //     $entidad->pais = $request->pais;
                // }
                // $entidad->id_empresa = $empresa;
                $entidad->save();
            }else{
                $entidad = new Entidad;
                $entidad->documento = $request->documento;
                $entidad->paterno = $request->paterno;
                $entidad->materno = $request->materno;
                $entidad->nombres = $request->nombres;
                $entidad->telefono = $request->telefono;
                $entidad->email = $request->email;
                $entidad->direccion = $request->direccion;
                $entidad->id_tipo_documento = 1;
                // if(isset($request->distrito)){
                    // $entidad->id_ubigeo = $request->distrito;
                // }
                // if(isset($request->pais)){
                //     $entidad->pais = $request->pais;
                // }
                // if($request->e=='true'){
                //     $entidad->extranjero = 1;
                // }
                $entidad->id_ubigeo = $request->distrito;
                // $entidad->id_empresa = $empresa;
                $entidad->save();
            }

            // $persona = json_decode(Crypt::decryptString($request->d));

            // if($request->q=='true'){
            //     $entidad = Entidad::find($persona->id);
            //     $entidad->telefono = $request->telefono;
            //     $entidad->email = $request->email;
            //     $entidad->direccion = $request->direccion;
            //     if(isset($request->distrito)){
            //         $entidad->id_ubigeo = $request->distrito;
            //     }
            //     if(isset($request->pais)){
            //         $entidad->pais = $request->pais;
            //     }
            //     $entidad->save();
            // }else{
            //     $entidad = new Entidad;
            //     $entidad->documento = $persona->documento;
            //     $entidad->paterno = $persona->paterno;
            //     $entidad->materno = $persona->materno;
            //     $entidad->nombres = $persona->nombres;
            //     $entidad->telefono = $request->telefono;
            //     $entidad->email = $request->email;
            //     $entidad->direccion = $request->direccion;
            //     $entidad->id_tipo_documento = 1;
            //     if(isset($request->distrito)){
            //         $entidad->id_ubigeo = $request->distrito;
            //     }
            //     if(isset($request->pais)){
            //         $entidad->pais = $request->pais;
            //     }
            //     if($request->e=='true'){
            //         $entidad->extranjero = 1;
            //     }
            //     $entidad->id_ubigeo = $request->distrito;
            //     $entidad->save();
            // }

            $array = [1,2,3,4,5,6,7,8,9,0];
            $password = Arr::random($array).Arr::random($array).Arr::random($array).Arr::random($array);
            
            $asunto = "";
            switch ($request->tipo_expediente) {
                case '1':
                    $proceso = Proceso::find($request->proceso);
                    $asunto = $proceso->nombre;
                        
                    break;
                case '2':
                    // $proceso = Proceso::find($request->proceso);
                    $asunto = $request->asunto;
                    break;
                case '3':
                    $asunto = $request->asunto;
                    break;
                default:
                    $asunto = "";
                    break;
            }
            // $random = Arr::random($array);
            $expediente = new Expediente;
            $expediente->solicitud_numero = $numero;
            $expediente->solicitud_codigo = $codigo;
            $expediente->asunto = $asunto;
            $expediente->numero_documento = $request->n_documento;
            $expediente->folio = $request->folio;
            $expediente->observacion = $request->observacion;
            // $expediente->numero_voucher = $request->numero;
            // $expediente->fecha_estado = date("Y-m-d H:i:s");
            $expediente->password = $password;
            $expediente->id_periodo = $periodo->id;
            $expediente->id_proceso = $request->proceso;
            $expediente->id_entidad = $entidad->id;
            $expediente->id_empresa = $empresa;
            $expediente->tipo_entidad = $request->tipo_persona;
            $expediente->save();

            if(isset($request->archivo)){

                foreach ($request->archivo as $key => $value) {
                    // $ids = explode("-",$key);
                    // var_dump($ids);
                    $req = DB::table("proceso_requisito as pr")
                            ->select("r.id","pr.orden","pr.tipo","r.nombre")
                            ->join("requisito as r","r.id","pr.id_requisito")
                            ->where("pr.id",$key)
                            ->first();
                        $nombreArchivo = Str::slug($req->nombre,'-').'-'.time().'.pdf';
                        $ruta = '/'.date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                        //$ruta = '/'.date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                        $path = $ruta."/".$nombreArchivo;
                        $archivo = $value;
            
                        Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);

                        $requisito = new ExpedienteRequisito;
                        $requisito->enlace = $path;
                        $requisito->id_requisito = $req->id;
                        $requisito->id_expediente = $expediente->id;
                        $requisito->tipo = $req->tipo;
                        $requisito->estado = 1;
                        $requisito->save();
                }
            }
            if(isset($request->adjunto)){

                foreach ($request->adjunto as $key => $value) {
                    // $ids = explode("-",$key);
                    // var_dump($ids);
                    // $req = DB::table("proceso_requisito as pr")
                    //         ->select("r.id","pr.orden","pr.tipo","r.nombre")
                    //         ->join("requisito as r","r.id","pr.id_requisito")
                    //         ->where("pr.id",$key)
                    //         ->first();
                    $nombreArchivo = Str::slug($value->getClientOriginalName(),'-').'-'.time().'.pdf';
                    $ruta = '/'.date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                    $path = $ruta."/".$nombreArchivo;
                    $archivo = $value;
        
                    Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);

                    $requisito = new ExpedienteRequisito;
                    $requisito->enlace = $path;
                    // $requisito->id_requisito = $req->id;
                    $requisito->id_expediente = $expediente->id;
                    $requisito->tipo = 1;
                    $requisito->estado = 1;
                    $requisito->save();
                }
            }

            try {
                //code...
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["codigo"] = $expediente->solicitud_codigo;
                $mensaje["password"] = $expediente->password;
                Mail::to($entidad->email)->send(new Mensaje($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $response["id"] = Crypt::encryptString($expediente->id);
            $message = 'Registrado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Registrar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        /**
         * Notificacion por correo electronico
         * STMP
         * Enviar Resumen de Solicitud
         *  - Combinar Anexos en un solo PDF
         *  
         * 
         */
        
        return $response;
    }
    public function success($id){
        $ide = Crypt::decryptString($id);
        $response["datos"] = DB::table("expediente as ex")
                        ->select(
                            "ex.solicitud_codigo as Codigo",
                            "ex.password as Password",
                            "e.documento as Documento",
                            "e.telefono as Telefono",
                            "e.email as Email",
                            DB::raw("CONCAT(e.paterno,' ',e.materno,' ',e.nombres) as Persona")
                            // DB::raw("DATE_FORMAT(.fecha,'%d/%m/%Y') as Fecha"),
                        )
                        ->join("entidad as e","e.id","ex.id_entidad")
                        ->where("ex.id",$ide)
                        ->first();
        // dd($response);
        $response["id"] = $id;

        return view("web.success",$response);
    }
    public function unidad(){
        // dd($id);
        $response = DB::table("proceso as p")
                    ->select("o.id","o.nombre")
                    ->join("oficina as o","o.id","p.id_oficina")
                    // ->where("p.id_clase",$id)
                    ->groupBy("o.id","o.nombre")
                    ->orderBy("o.id","asc")
                    ->get();
        return $response;
    }
    public function proceso(Request $request){
        // dd($id);
        if($request->tipo==1){
            $response = DB::table("proceso as p")
                        ->select("p.id","p.nombre")
                        // ->join("requisito as r","r.id","pr.id_requisito")
                        ->where("p.tipo",1)
                        ->where("p.id_oficina",$request->unidad)
                        ->get();
        }
        if($request->tipo==2){
            $response = DB::table("proceso as p")
                        ->select("p.id","p.nombre")
                        // ->join("requisito as r","r.id","pr.id_requisito")
                        ->where("p.tipo",2)
                        // ->where("p.id_oficina",$request->unidad)
                        ->get();
        }
        if($request->tipo==3){
            $proceso = DB::table("proceso as p")
                        ->select("p.id","p.nombre")
                        // ->join("requisito as r","r.id","pr.id_requisito")
                        ->where("p.tipo",3)
                        // ->where("p.id_oficina",$request->unidad)
                        ->first();
            $response["proceso"] = $proceso;
            $response["requisitos"] = DB::table("proceso_requisito as pr")
                        ->select("pr.id as id","pr.orden","pr.tipo","r.nombre")
                        ->join("requisito as r","r.id","pr.id_requisito")
                        ->where("pr.id_proceso",$proceso->id)
                        ->orderBy("pr.orden","asc")
                        ->get();
            $response["formatos"] = DB::table("proceso_requisito as pr")
                        ->select("pr.id as id","pr.orden","pr.tipo","r.nombre","r.enlace")
                        ->join("requisito as r","r.id","pr.id_requisito")
                        ->where("pr.id_proceso",$proceso->id)
                        ->where("r.formato",1)
                        ->orderBy("pr.orden","asc")
                        ->get();
        }
        return $response;
    }
    public function requisitos($id){
        // dd($id);
        $response["requisitos"] = DB::table("proceso_requisito as pr")
                    ->select("pr.id as id","pr.orden","pr.tipo","r.nombre")
                    ->join("requisito as r","r.id","pr.id_requisito")
                    ->where("pr.id_proceso",$id)
                    ->orderBy("pr.orden","asc")
                    ->get();
        $response["formatos"] = DB::table("proceso_requisito as pr")
                    ->select("pr.id as id","pr.orden","pr.tipo","r.nombre","r.enlace")
                    ->join("requisito as r","r.id","pr.id_requisito")
                    ->where("pr.id_proceso",$id)
                    ->where("r.formato",1)
                    ->orderBy("pr.orden","asc")
                    ->get();
        return $response;
    }

    public function habilitado(){
        $config = DB::table("configuracion")
                ->where("estado",1)
                ->first();
        // dd($config);
        $status = true;
        $message = "";
        // dd($semna);
        $fecha_hoy = date("Y-m-d");
        $feriado = DB::table("feriado")
                    ->where("fecha",$fecha_hoy)
                    ->first();

        if($feriado){
            $response["status"] = false;
            $response["message"] = $feriado->nota;
            return $response;
        }
        
        
        if($config){
            $fecha_actual = new \DateTime(date("d-m-Y H:i:00",time()));
            $semana_actual = $fecha_actual->format('N');

            // $hora_actual = strtotime(date("d-m-Y H:i:00",time()))
            $hora_ini = $config->hora_ini;
            $hora_fin = $config->hora_fin;

            $semanas = explode(",",$config->dias);
            foreach ($semanas as $key => $value) {
                if($value!=$semana_actual)
                {
                    // echo "dia No habilitado <br>";
                    $status = false;
                    $message = $config->nota;
                }else{
                    // echo "dia habilitainado <br>";
                    // $ThatTime ="14:08:10";
                    if (time() >= strtotime($hora_ini)&&time() <= strtotime($hora_fin)) {
                        $status = true;
                        $message = $config->nota;
                        break;
                    }else{
                        $status = false;
                        $message = $config->nota;
                    }
                }
            }

            // $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));
            // $fecha_entrada = strtotime("19-11-2008 21:00:00");
        }
        $response["status"] = $status;
        $response["message"] = $message.time();
        return $response;
    }
}
