<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
// use Peru\Http\ContextClient;
// use Peru\Jne\{Dni, DniParser};
use Peru\Jne\DniFactory;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;

class PeruConsultController extends Controller
{
	public function onlyDni($dni){
		try {

			// $cs = new Dni(new ContextClient(), new DniParser());
			// $dni = $request->documento;

			$factory = new DniFactory();
			$cs = $factory->create();

			$person = $cs->get($dni);
			// $person = $cs->get($dni);
			if ($person === false) {
			    // echo $cs->getError();
			    // exit();
			    $response["message"]= "Datos Incorrectos.";
			    $response["status"]= false;
			    // $response["query"] = true;
			}else{
				$postulante = new \stdClass();
				$postulante->documento = $person->dni;
				$postulante->nombres = $person->nombres;
				$postulante->paterno = $person->apellidoPaterno;
				$postulante->materno = $person->apellidoMaterno;

				// $response["query"] = false;
				$response["status"]= true;
				$response["result"]= $postulante;
			}
		} catch (\Exception $e) {
            $response["message"]= "Datos Incorrectos.";
			$response["status"]= false;
			// $response["query"] = false;
        }
		return $response;
	}
    public function dni(Request $request){
		$response["extranjero"] = false;
    	try {

			// $cs = new Dni(new ContextClient(), new DniParser());
			$dni = $request->documento;

			$factory = new DniFactory();
			$cs = $factory->create();

			$person = $cs->get($dni);
			// $person = $cs->get($dni);
			if ($person === false) {
			    // echo $cs->getError();
			    // exit();
			    $response["message"]= "Datos Incorrectos.";
			    $response["status"]= false;
			    $response["query"] = true;
			}else{
				// echo json_encode($person);
			    // dd($person->dni);
			    if($person->codVerifica==$request->numero){
			    	$query = DB::table("entidad as e")
			    			->select(
			    				"e.*"
			    				// DB::raw("DATE_FORMAT(p.updated_at,'%Y-%m-%d') as Fecha")
			    			)
			    			->where("e.documento",$person->dni)
			    			->first();
			    	if($query)
			    	{
			    		$response["status"] = true;
			    		$response["query"] = true;
			    		$response["d"] = Crypt::encryptString(json_encode($query));
			    	}else{
			    		// $response["status"] = false;
			    		$postulante = new \stdClass();
			    		$postulante->id = "";
			    		$postulante->documento = $person->dni;
			    		$postulante->nombres = $person->nombres;
			    		$postulante->paterno = $person->apellidoPaterno;
			    		$postulante->materno = $person->apellidoMaterno;
			    		$postulante->telefono = "";
			    		$postulante->email = "";

						// $response["message"]= "Datos Correctos.";
			    		$response["query"] = false;
					    $response["status"]= true;
				    	$response["d"]= Crypt::encryptString(json_encode($postulante));;
			    	}
			    }else{
			    	$response["message"]= "Datos Incorrectos.";
				    $response["status"]= false;
				    $response["query"] = false;
			    }
			}
		} catch (\Exception $e) {
            $response["message"]= "Datos Incorrectos.";
			$response["status"]= false;
			$response["query"] = false;
        }
		return $response;
    }
	public function extranjero(Request $request){

		$response["extranjero"] = true;
		DB::beginTransaction();
        try {
			$query = DB::table("entidad")
						->where("documento",$request->documento)
						->first();
			if($query){
				$response["status"] = true;
			    $response["query"] = true;
				$response["d"]= Crypt::encryptString(json_encode($query));;
			}else{
				$postulante = new \stdClass();
				$postulante->id = "";
				$postulante->documento = $request->documento;
				$postulante->nombres = $request->nombres;
				$postulante->paterno = $request->paterno;
				$postulante->materno = $request->materno;

				// $response["message"]= "Datos Correctos.";
				$response["query"] = false;
				$response["status"]= true;
				$response["d"]= Crypt::encryptString(json_encode($postulante));;
			}
			DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            $response["message"]= "Datos Incorrectos.";
			$response["status"]= false;
			$response["query"] = false;
        }
        return $response;
	}
}
