<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use App\Models\Firma;
use App\Models\FirmaParametros;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class FirmaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    /**
     *  Firma Electronica Peru
     *  Client_ide
     *  Secret_ide 
     * 
     */
    //private $Client_id = '';
    //private $Secret_id = '';

    public function index(Request $request)
    {
        $_session = Auth::user()->id_oficina;

        if ($request->input('datatable')) {
            $response = DB::table("firma as f")
                ->select(
                    "f.fir_ide as RowId",
                    "f.fir_file_name as Nombre",
                    DB::raw("IF(f.fir_sign=1,'Si','No') as Firmado"),
                    "fir_file_path as Enlace",
                    DB::raw('"" as Botones')
                )->where('f.fir_user_ide','=',$_session)
                ;
            $response = $response->get();
            return DataTables::of($response)->make('true');
            //return DataTables()->query($response)->toJson();
        }

        return view("extranet.configuracion.firma");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //DB::beginTransaction();

        $_session = Auth::user()->id_oficina;
        //echo $_session;
        //return 0;
        try {


            $path = "";
            if (isset($request->archivo)) {

                $nombreArchivo = Str::slug($request->nombre, '-') . '-' . time() . '.pdf';
                $ruta = '/firma';
                $path = $ruta . "/" . $nombreArchivo;
                $archivo = $request->archivo;

                Storage::disk('firma')->putFileAs($ruta, $archivo, $nombreArchivo);
            }
            $data = new Firma;
            $data->fir_user_ide = $_session;
            $data->fir_file_name = $request->nombre;
            $data->fir_file_path = $path;
            $data->save();

            DB::commit();
            $message = 'Guardado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.'.$e;
            $status = false;
        }

        /*Firma::create([
            'fir_file_name' => $archivo,
            'fir_file_path' => $path,
        ]);
        */

        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $response["data"] = DB::table("requisito")
            ->where("id", $id)
            ->first();
        return $response;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {

            $data = Firma::find($id);
            $data->nombre = $request->nombre;
            $data->save();

            DB::commit();
            $message = 'Editado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Editar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function editar(Request $request, $id)
    {
        // dd($request);
        DB::beginTransaction();
        try {
            $data = Firma::find($id);
            $path = "";
            if ($request->formato == '1') {
                if (isset($request->archivo)) {

                    $nombreArchivo = Str::slug($request->nombre, '-') . '-' . time() . '.pdf';
                    $ruta = '/requisitos';
                    $path = $ruta . "/" . $nombreArchivo;
                    $archivo = $request->archivo;

                    Storage::disk('formatos')->putFileAs($ruta, $archivo, $nombreArchivo);
                }
            } else {
                Storage::deleteDirectory("formatos" . $data->enlace);
            }


            $data->nombre = $request->nombre;
            $data->formato = $request->formato;
            $data->enlace = $path;
            $data->save();

            DB::commit();
            $message = 'Editado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Editar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Retorna el link del docuemnto acorde  a la ide
     */
    public function iniciarFirma(Request $request)
    {
        // creamos y almacenamos sus parametros
        // retornamos el url con el id de los parametros
        //echo $request->input('fir_ide').' ';
        //return 0;
        $docUrlDownload = $this->linkDocumentoOriginal(request()->input('fir_ide'));
        $docUrlUpload = $this->linkDocumentoSubida(request()->input('fir_ide'));
        $_cargo = 'Asistente OTI';
        $_tema = 'oscuro';
        $_contactoInfo = 'OTI-UNAJ';
        $_razon = 'Firmo como Autor';
        $_estiloFirma = 3;
        $token = Str::random(20);

        // rellenamos los parametros a usar en esta firma
        $request->merge([
            'documentToSign' => $docUrlDownload,
            'theme' => $_tema,
            'contactInfo' => $_contactoInfo,
            'signatureReason' => $_razon,
            'signatureStyle' => 3,
            'role' => $_cargo,
            'stampPage' => 1,
            'uploadDocumentSigned' => $docUrlUpload,
            'token' => $this->ObtenerToken(),
            'param_token' => $token,

        ]);

        // guardamos y obtenemos el id para los parametros de firma
        $id_parametros = $this->guardarParametrosJson($request);
        // param_token
        $param_url = url('/api/v1/parametros/' . $id_parametros);
        // token interno del sistema
        // tipo de extension del archivo
        $extension = 'pdf'; // 7z

        $data = array(
            'status' => true,
            'message' => 'Proceso de Firma Iniciado',
            'param' => [
                'param_url' => $param_url,
                'param_token' => $token,
                'document_extension' => $extension
            ],
        );

        return json_encode($data);
    }

    public function guardarParametrosJson(Request $request)
    {
        $urlImg = url('/img/unaj.png');

        $firmaParametro = new FirmaParametros();
        // Asignar valores solo si existen en la solicitud
        $firmaParametro->signatureFormat = $request->input('signatureFormat', 'PAdES');
        $firmaParametro->signatureLevel = $request->input('signatureLevel', 'B');
        $firmaParametro->signaturePackaging = $request->input('signaturePackaging', 'enveloped');
        $firmaParametro->documentToSign = $request->input('documentToSign', '');
        $firmaParametro->certificateFilter = $request->input('certificateFilter', '.*');
        $firmaParametro->webTsa = $request->input('webTsa', '');
        $firmaParametro->userTsa = $request->input('userTsa', '');
        $firmaParametro->passwordTsa = $request->input('passwordTsa', '');
        $firmaParametro->theme = $request->input('theme', 'claro');
        $firmaParametro->visiblePosition = $request->input('visiblePosition', true);
        $firmaParametro->contactInfo = $request->input('contactInfo', '');
        $firmaParametro->signatureReason = $request->input('signatureReason', 'Soy Autor');
        $firmaParametro->bachtOperation = $request->input('bachtOperation', false);
        $firmaParametro->oneByOne = $request->input('oneByOne', true);
        $firmaParametro->signatureStyle = $request->input('signatureStyle', 1);
        $firmaParametro->imageToStamp = $request->input('imageToStamp', $urlImg);
        $firmaParametro->stampTextSize = $request->input('stampTextSize', 14);
        $firmaParametro->stampWordWrap = $request->input('stampWordWrap', 37);
        $firmaParametro->role = $request->input('role', 'Asistente de OTI');
        $firmaParametro->stampPage = $request->input('stampPage', 1);
        $firmaParametro->positionx = $request->input('positionx', 100);
        $firmaParametro->positiony = $request->input('positiony', 100);
        $firmaParametro->uploadDocumentSigned = $request->input('uploadDocumentSigned', '');
        $firmaParametro->certificationSignature = $request->input('certificationSignature', false);
        $firmaParametro->token = $request->input('token', '');

        $firmaParametro->param_token = $request->input('token', '');
        $firmaParametro->fir_ide = $request->input('fir_ide', '');


        // Guardar la instancia en la base de datos
        $firmaParametro->save();

        // Obtener el ID de la firma guardada
        $firmaParametroId = $firmaParametro->id;

        return $firmaParametroId;
    }

    public function obtenerParametrosJson($fp_ide)
    {

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $documentoFirma = FirmaParametros::find($fp_ide);
            if ($documentoFirma) {
                // Eliminar las columnas que no deseas
                $documentoFirma->forget(['fir_ide', 'param_url', 'id']);

                // Obtener los datos como un array
                $respuesta = $documentoFirma->toArray();
                header('Content-Type: application/x-www-form-urlencoded');
                $json = json_encode($respuesta);
                $base64 = base64_encode($json);
                echo $base64;
            } else {
                // Manejar el caso en que no se encuentra ningún resultado
                return response()->json(['error' => 'No se encontró el documento de firma'], 404);
            }
        } else {
            // Si la solicitud no es POST, enviar un mensaje de error
            http_response_code(405); // Method Not Allowed
            echo http_build_query(array('error' => 'Método no permitido'));
        }
    }
    public function listar() {
        $postres = FirmaParametros::all();
        return response()->json($postres);
    }
    public function ObtenerToken()
    {
        // Datos que se enviarán en el cuerpo de la solicitud
        $data = array(
            'client_id' => 'Kyw80HQQeDIwNDQ4MjYxMjcys91h5NM_6Q',
            'client_secret' => 'ZZAh4IENFN5SY06Mu56FX8Tc9RWcP5nDkEw',
            // Agrega más parámetros según sea necesario
        );

        // Convertir los datos a formato x-www-form-urlencoded
        $postData = http_build_query($data);

        // Inicializar una sesión cURL
        $curl = curl_init();

        // Establecer la URL de destino
        curl_setopt($curl, CURLOPT_URL, 'https://apps.firmaperu.gob.pe/admin/api/security/generate-token');

        // Especificar que se realizará una solicitud POST
        curl_setopt($curl, CURLOPT_POST, true);

        // Establecer los datos que se enviarán en el cuerpo de la solicitud
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postData);

        // Indicar que se desea recibir la respuesta del servidor como cadena
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

        // Realizar la solicitud y obtener la respuesta
        $response = curl_exec($curl);

        // Verificar si hubo algún error
        if ($response === false) {
            // Mostrar el mensaje de error si falla la solicitud
            return 'Error de cURL: ' . curl_error($curl);
        } else {
            // Mostrar la respuesta del servidor
            // echo 'Respuesta del servidor: ' . $response;
        }

        // Cerrar la sesión cURL
        curl_close($curl);

        return $response;
    }

    function linkDocumentoOriginal($fir_ide): string
    {
        $documentoFirma =  Firma::where('fir_ide', $fir_ide)->first();
        //print_r($documentoFirma);
        $url = url('/storage/firma/' . $documentoFirma->fir_file_path);
        // retornar un url
        return $url;
    }
    /**
     * Retorna el link con el id de documento a firmar
     */
    function linkDocumentoSubida($fir_ide): string
    {
        $documentoFirma = Firma::find($fir_ide);
        $url = url('/firmadigital/subirdocumentofirmado/' . $documentoFirma->fir_ide);
        return $url;
    }
    /**
     * RECIBIRDOCUMENTOFIRMADO
     * recibe un tipo POST con el documento firmado
     * y lo almacena acorde al id proveido 
     * en este caso el ide de la tabla Firma
     * $fir_ide
     */

    public function subirDocumentoFirmado($fir_ide)
    {
        // el documento llega con nombre signed_file
        $documentoFirma = Firma::find($fir_ide);
        $url = url('/api/v1/subirpdf/' . $documentoFirma->fir_ide);

        $file = request()->file('signed_file');

        // Definir la ruta de destino
        $destinationPath = '/firma/';

        // Si es necesario, crea el directorio para los documentos firmados
        if (!Storage::exists($destinationPath)) {
            Storage::makeDirectory($destinationPath);
        }

        // Generar un nombre único para el archivo basado en el ID y el nombre original
        $filename = $documentoFirma->fir_file_path;
        $path = $filename;

        // Eliminar el archivo existente si ya existe
        if (Storage::exists($path)) {
            Storage::delete($path);
        }

        // Mover el archivo a la ubicación de destino
        $storedPath = $file->storeAs($destinationPath, $filename);

        if ($storedPath) {
            return response()->json(['message' => 'Documento firmado guardado con éxito como: ' . $storedPath], 200);
        } else {
            return response()->json(['error' => 'Error al guardar el documento firmado.'], 500);
        }
    }
    public function firmadorSelect2(Request $request){
        
        $_session = Auth::user()->id_oficina;
        $search = $request->q;
        $response["items"] = DB::table("oficina as o")
                ->select(
                    "o.id",
                    DB::raw("o.nombre as text"),    
                )//->where('o.nombre','like','%$search%' )
                ->where('o.id','=',$_session)->get();
        return $response;
    }
    public function razonSelect2(Request $request){
        
        $_session = Auth::user()->id_oficina;
        $search = $request->q;
        $_razon['items'] = array(
            array('id'=>'Soy el Autor','text'=>'Soy el Autor'),
            array('id'=>'En señal de Conformidad','text'=>'En señal de Conformidad'),
            array('id'=>'Doy VoBo','text'=>'Doy VoBo'),
        );
        $response["items"] = DB::table("oficina as o")
                ->select(
                    "o.id",
                    DB::raw("o.nombre as text"),    
                )//->where('o.nombre','like','%$search%' )
                ->where('o.id','=',$_session)->get();
        //return $response;
        return $_razon;
    }
    public function orientacionSelect2(Request $request){
        
        $_session = Auth::user()->id_oficina;
        $search = $request->q;
        $_orientacion['items'] = array(
            array('id'=>0,'text'=>'Invisible'),
            array('id'=>1,'text'=>'Horizontal'),
            array('id'=>2,'text'=>'Vertical'),
            array('id'=>3,'text'=>'Solo Estampado'),
            array('id'=>4,'text'=>'Solo Descripción'),
        );
        return $_orientacion;
    }

}