<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\DataTables;
use App\Models\Tramite;
use App\Models\Expediente;
use App\Models\ExpedienteArchivo;
use App\Models\Archivo;
use App\Models\ExpedienteRequisito;
use App\Models\Adjunto;
use App\Models\ExpedienteAdjunto;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Crypt;
use App\Mail\Seguimiento;
use Illuminate\Support\Facades\Mail;
use LynX39\LaraPdfMerger\Facades\PdfMerger;

class TramiteController extends Controller
{
    public function index()
    {
        $response["proceso"] = DB::table("proceso")->get();
        return view('extranet.tramite.index',$response);
    }
    public function lista(Request $request){

        	$id_oficina  = Auth::user()->id_oficina;
            $response = DB::table("tramite as t")
                        ->select(
                        	"t.id as RowId",
                            "e.id as RowIdEx",
                            "e.codigo as CodigoExpediente",
                            // "et.nombre as TipoExpediente",
                            // "e.numero_expediente as NumeroDocumento",
                            "e.asunto as Asunto",
                            DB::raw("DATE_FORMAT(t.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),

                            DB::raw("CASE 
                                    WHEN t.estado = 0 THEN 'Pendiente'
                                    WHEN t.estado = 1 THEN 'Recibido'
                                    WHEN t.estado = 2 THEN 'Derivado'
                                    WHEN t.estado = 3 THEN 'Rechazado'
                                    WHEN t.estado = 4 THEN 'Finalizado'
                                    WHEN t.estado = 5 THEN 'Archivado'
                                    WHEN t.estado = 6 THEN 'Observador'
                                    ELSE ''
                                    END AS Estado"),
                            "t.estado as EstadoNumero",
                            "t.observacion as Observacion",
                            "o.nombre as Oficina",
                            DB::raw("CASE 
                                WHEN p.tipo = 1 THEN 'Tupa'
                                WHEN p.tipo = 2 THEN 'No Tupa'
                                WHEN p.tipo = 3 THEN 'Otro'
                                ELSE 'Otro'
                                END AS TipoExpediente"),
                            "p.nombre as Proceso",

                            // DB::raw("CASE 
                            //         WHEN en.tipo = 0 THEN 'Persona Natural'
                            //         WHEN en.tipo = 1 THEN 'Persona Juridica'
                            //         ELSE ''
                            //         END AS TipoPersona"),
                            DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Responsable"),
                            // DB::raw("CONCAT(em.ruc,'|',em.empresa) as Empresa"),

                            DB::raw('"" as Botones')
                        )
                        ->join("expediente as e","e.id","t.id_expediente")
                        ->leftJoin("entidad as en","en.id","e.id_entidad")
                        ->join("proceso as p","p.id","e.id_proceso")
                        ->leftJoin("oficina as o","o.id","t.id_oficina_destino")
                        ->where("t.id_oficina",$id_oficina)
                        ->orderBy("t.created_at","desc");
            if(isset($request->estado)):
                $response = $response->where('t.estado',$request->estado);
            endif;
            if(isset($request->servicio)):
                $response = $response->where('p.id_servicio',$request->servicio);
            endif;
            return DataTables::of($response->get())
                    ->make('true'); 
            // return DataTables()->query($response)->toJson();
    }
    public function recibir($id){

        DB::beginTransaction();
        try {
            $id_users  = Auth::user()->id;
            $tramite = Tramite::find($id);
            $tramite->estado = 1;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            // $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
            try {
                //code...
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Recibido";
                $mensaje["observacion"] = "";
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

        DB::commit();
            $message = 'Recibido.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Recibir. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function revisar($id){
        // dd();
        $id_oficina  = Auth::user()->id_oficina;
    	$response["tramite"] = DB::table("tramite as t")
    			->select(
    				"t.id as RowId",
    				"t.id_expediente",
    				DB::raw("DATE_FORMAT(t.fecha_estado,'%d/%m/%Y %h:%i %p') as FechaEstado"),
    				DB::raw("CASE 
                            WHEN t.estado = 0 THEN 'Pendiente'
                            WHEN t.estado = 1 THEN 'Recibido'
                            WHEN t.estado = 2 THEN 'Derivado'
                            WHEN t.estado = 3 THEN 'Rechazado'
                            WHEN t.estado = 4 THEN 'Finalizado'
                            WHEN t.estado = 5 THEN 'Archivado'
                            WHEN t.estado = 6 THEN 'Observado'
                            ELSE ''
                            END AS Estado"),
                    "t.estado",
                    "t.copia",
                    "t.observacion as Observacion",
                    "o.nombre as Oficina",
                    "od.nombre as OficinaDestino"
    			)
    			->join("oficina as o","o.id","t.id_oficina")
    			->leftJoin("oficina as od","od.id","t.id_oficina_destino")
    			->where("t.id",$id)
    			->first();
    	// dd($response);
    	$response["expediente"] = DB::table("expediente as e")
	            ->select(
	                "e.id as RowId",
	                "e.codigo as CodigoExpediente",
	                "e.solicitud_codigo as CodigoSolicitud",
                    "e.numero_documento as NumeroDocumento",
	                "e.asunto as Asunto",
                    "e.folio as Folio",
                    "e.observacion as Observacion",
	                // "e.numero_expediente as NumeroDocumento",
	                DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),

                    DB::raw("CASE 
	                        WHEN e.estado = 0 THEN 'Pendiente'
	                        WHEN e.estado = 1 THEN 'En tramite'
	                        WHEN e.estado = 2 THEN 'Rechazado'
	                        ELSE 'Pendiente'
	                        END AS Estado"),
	                "e.estado",
                    "e.tipo_entidad as TipoEntidad",

                    DB::raw("CASE 
	                        WHEN e.tipo = 1 THEN 'Externo'
	                        WHEN e.tipo = 2 THEN 'Interno'
	                        ELSE 'Interno'
	                        END AS Tipo"),

	                "td.nombre as TipoDocumento",
	                DB::raw("CONCAT(en.documento,' | ',IFNULL(en.paterno,''),' ',IFNULL(en.materno,''),' ',IFNULL(en.nombres,'')) as Responsable"),
	                "en.telefono as Telefono",
	                "en.email as Email",
	                "en.direccion as Direccion",
	                "en.id_ubigeo as Ubigeo",
                    "en.extranjero as Extranjero",
                    "en.pais as Pais",

                    "em.ruc as Ruc",
                    "em.razon_social as RazonSocial",
                    "em.direccion as DireccionEmpresa",

                    DB::raw("CASE 
                        WHEN p.tipo = 1 THEN 'Tupa'
                        WHEN p.tipo = 2 THEN 'No Tupa'
                        WHEN p.tipo = 3 THEN 'Otro'
                        ELSE 'Otro'
                        END AS TipoExpediente"),
                    "p.nombre as Proceso",
                    "p.tipo as IdTipo",
                    "p.id as IdProceso",
	                // DB::raw("CONCAT(em.ruc,' | ',em.empresa) as Empresa"),
	                "o.nombre as Oficina",

	                DB::raw('"" as Botones')
	            )
	            ->leftJoin("entidad as en","en.id","e.id_entidad")
                ->leftJoin("empresa as em","em.id","e.id_empresa")
                ->leftJoin("oficina as o","o.id","e.id_oficina")
                // ->leftJoin("empresa as em","em.id","en.id_empresa")
	            ->leftJoin("tipo_documento as td","td.id","en.id_tipo_documento")
	            ->join("proceso as p","p.id","e.id_proceso")
	            ->where("e.id",$response["tramite"]->id_expediente)
	            ->first();
        // dd($response);
        if(isset($response["expediente"]->Ubigeo)){
            $response['distrito'] = DB::table('ubigeo')
                                ->select('nombre','provincia','departamento')
                                ->where('id',$response["expediente"]->Ubigeo)
                                ->first();

            $response['provincia'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('provincia',$response['distrito']->provincia)
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('distrito','0')
                            ->first();

            $response['departamento'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('provincia','0')
                            ->where('distrito','0')
                            ->first();
        }

        $response["requisitos"] = DB::table("expediente_requisito as er")
                        ->select("r.nombre","er.*")
                        ->leftJoin("requisito as r","r.id","er.id_requisito")
                        ->where("er.id_expediente",$response["tramite"]->id_expediente)
                        ->orderby("er.tipo","asc")
                        // ->where("ea.tipo",0)
                        ->get();            
        $response["adjuntos"] = DB::table("expediente_adjunto as ea")
                        ->select("a.*","o.nombre as Oficina")
                        ->join("adjunto as a","a.id","ea.id_adjunto")
                        ->join("oficina as o","o.id","a.id_oficina")
                        ->where("ea.id_expediente",$response["tramite"]->id_expediente)
                        ->get();            
        $response["all_requisitos"] = DB::table("requisito")
                            ->get();

        if ($response["expediente"]->IdTipo==1) {
            $proceso_detalle = DB::table("proceso_detalle")
                            ->where("id_oficina",$id_oficina)
                            ->where("id_proceso",$response["expediente"]->IdProceso)
                            ->first();

            $next_oficina = DB::table("proceso_detalle as pd")
                            ->select("pd.*","o.nombre as Oficina")
                            ->where("orden",($proceso_detalle->orden+1))
                            ->where("id_proceso",$response["expediente"]->IdProceso)
                            ->join("oficina as o","o.id","pd.id_oficina")
                            ->first();
            // $oficina = $next_oficina;
            $response["oficina"] = $next_oficina;
        }
        $response["procesos"] = DB::table("proceso")
                            ->where("tipo",0)
                            ->get();
        return view("extranet.tramite.revisar",$response);
        // dd($response);
    }
    public function merge($id){
        $query = DB::table("expediente_requisito")
                ->where("id_expediente",$id)
                ->whereIn("tipo",[1,2])
                ->where("estado",1)
                ->get();

        $pdfMerger = PDFMerger::init();

        foreach ($query as $key => $value) {
            # code...
            $pdfMerger->addPDF('storage/expediente'.$value->enlace, 'all');
        }

        $pdfMerger->merge();

        $pdfMerger->save("todos_los_archivos.pdf", "browser");
    }
    public function derivar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;


            $tramite = Tramite::find($id);
            $tramite->estado = 2;
            $tramite->id_oficina_destino = $request->oficina;
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            if(isset($request->copia)){
                foreach ($request->copia as $key => $value) {
                    $copia = new Tramite;
                    $copia->id_expediente = $tramite->id_expediente;
                    $copia->id_oficina = $value;
                    $copia->observacion ="Copia - ".$request->observacion;
                    $copia->fecha_estado = date("Y-m-d H:i:s");
                    $copia->copia = 1;
                    $copia->save();
                }
            }


            $newtramite = new Tramite;
            $newtramite->id_expediente = $tramite->id_expediente;
            $newtramite->id_oficina = $request->oficina;
            $newtramite->observacion = $request->observacion;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            $expediente = Expediente::find($tramite->id_expediente);
            $expediente->observacion = $request->observacion;
            $expediente->save();
            
            try {
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Derivado";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
                //code...
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $message = 'Expediente Derivado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Derivar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function rechazar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;


            $tramite = Tramite::find($id);
            $tramite->estado = 3;
            $tramite->id_oficina_destino = $request->regresar;
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            $newtramite = new Tramite;
            $newtramite->id_expediente = $tramite->id_expediente;
            $newtramite->id_oficina = $request->regresar;
            $newtramite->observacion = $request->observacion;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            $expediente = Expediente::find($tramite->id_expediente);
            $expediente->observacion = $request->observacion;
            $expediente->save();

            try {
                //code...
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Retroceso";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $message = 'Expediente Rechazado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Rechazado. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function observar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;

            $tramite = Tramite::find($id);
            $tramite->estado = 6;
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            $expediente = Expediente::find($tramite->id_expediente);
            $expediente->observacion = $request->observacion;
            $expediente->save();
            if(isset($request->requisito)){
                foreach($request->requisito as $value)
                {
                    $requisito = new ExpedienteRequisito;
                    $requisito->id_requisito = $value;
                    $requisito->id_expediente = $tramite->id_expediente;
                    $requisito->tipo = 2;
                    $requisito->observado = 1;
                    $requisito->save();
                }
            }

            try {
                //code...
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Observado";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $message = 'Expediente Observado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Observado. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function finalizar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;

            $tramite = Tramite::find($id);
            $tramite->estado = 4;
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            $expediente = Expediente::find($tramite->id_expediente);
            $expediente->estado = 3;
            $expediente->observacion = $request->observacion;
            $expediente->save();

            try {
                //code...
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Finalizado";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $message = 'Expediente Finalizado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Finalizar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function archivar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;

            $tramite = Tramite::find($id);
            $tramite->estado = 5;
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            DB::commit();
            $message = 'Expediente Archivado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Archivado. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function notificar(Request $request,$id){
    	// dd($request);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;

            $tramite = Tramite::find($id);
            $tramite->observacion = $request->observacion;
            $tramite->id_users = $id_users;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            $expediente = Expediente::find($tramite->id_expediente);
            $expediente->observacion = $request->observacion;
            $expediente->save();

            try {
                //code...
                $entidad = DB::table("expediente as e")
                        ->select("en.*")
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->where("e.id",$tramite->id_expediente)
                        ->first();
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Notificado";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($tramite->id_expediente);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $message = 'Expediente Notificado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Notificado. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function subir_archivo(Request $request,$id){
        // dd($request->file("archivo"));
        // dd($request);
        DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;
            $id_oficina  = Auth::user()->id_oficina;
            // dd($id_oficina);

            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("numero")
                ->where("id_periodo",$periodo->id)
                ->where("id_oficina",$id_oficina)
                // ->where("id_expediente_tipo",$request->expediente_tipo)
                ->where("tipo",1)
                ->orderBy("numero","desc")
                ->first();
                $numero = 1;

            if($query){
                $numero = (int)$query->numero + 1;
            }
            // $periodo = "19";
            $codigo = "I-".str_pad($id_oficina, 2, "0", STR_PAD_LEFT)."-".str_pad($numero, 4, "0", STR_PAD_LEFT)."-".$periodo->nombre;

            $data = new Expediente;
            $data->numero = $numero;
            $data->codigo = $codigo;
            $data->numero_documento = $request->n_documento;
            $data->id_proceso = $request->proceso;
            // $data->folio = $request->n_folio;
            $data->asunto = $request->asunto;
            // $data->comentario = $request->comentario;
            $data->tipo = 2;
            // $data->fecha_reg = date("Y-m-d");
            $data->id_periodo = $periodo->id;
            $data->id_users = $id_users;
            $data->id_oficina = $id_oficina;
            $data->save();

            if(isset($request->archivo)){
                $nombre = $request->archivo->getClientOriginalName();
                $nombreArchivo = Str::slug($nombre ,'-').'-'.time().'.pdf';
                $ruta = '/interno/'.date('Y').'/'.date("m").'/'.date("d").'/'.$id_oficina;
                $path = $ruta."/".$nombreArchivo;
                $archivo = $request->archivo;

                Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);
            }


            $archivo = new Adjunto;
            // $archivo->id_expediente = $id;
            $archivo->nombre = $nombre;
            $archivo->enlace = $path;
            $archivo->id_oficina = $id_oficina;
            $archivo->save();

            $expe_archivo1 = new ExpedienteAdjunto;
            $expe_archivo1->id_adjunto = $archivo->id;
            $expe_archivo1->id_expediente = $data->id;
            $expe_archivo1->save();

            $expe_archivo2 = new ExpedienteAdjunto;
            $expe_archivo2->id_adjunto = $archivo->id;
            $expe_archivo2->id_expediente = $id;
            $expe_archivo2->save();


            DB::commit();
            $message = 'Archivo Adjuntado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Adjutar Archivo. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function seguimiento($id){
    	$response["tramite"] = DB::table("tramite as t")
                ->select(
                    "o.nombre as Oficina",
                    DB::raw("IFNULL(od.nombre, '') as Destino"),
                    DB::raw("CASE 
                            WHEN t.estado = 0 THEN 'Pendiente'
                            WHEN t.estado = 1 THEN 'Recibido'
                            WHEN t.estado = 2 THEN 'Derivado'
                            WHEN t.estado = 3 THEN 'Rechazado'
                            WHEN t.estado = 4 THEN 'Finalizado'
                            WHEN t.estado = 5 THEN 'Archivado'
                            WHEN t.estado = 6 THEN 'Observado'
                            ELSE ''
                            END AS Estado"),
                    // "t.copia",
                    DB::raw("IFNULL(t.observacion,'') as Observacion")
                )
                ->join("oficina as o","o.id","t.id_oficina")
                ->leftJoin("oficina as od","od.id","t.id_oficina_destino")
                ->where("t.id_expediente",$id)
                ->orderBy("t.id","asc")
                ->get();
        return $response;
    }
    public function formatos(Request $request){

        if ($request->input('datatable')) {

            $id_oficina  = Auth::user()->id_oficina;
            $response = DB::table("plantilla as p")
                        ->select(
                            "p.id as RowId",
                            "p.nombre as Nombre",
                            "p.archivo as Archivo",
                            DB::raw('"" as Botones')
                        )
                        ->where("p.id_oficina",$id_oficina);

            return DataTables::of($response)
                    ->make('true'); 
        }
            // return DataTable
    }
}
