<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Requisito;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Str;

class RequisitoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->input('datatable')) {
            $response = DB::table("requisito as r")
                        ->select(
                            "r.id as RowId",
                            "r.nombre as Nombre",
                            DB::raw("IF(r.formato=1,'Si','No') as Formato"),
                            "formato",
                            "enlace as Enlace",
                            DB::raw('"" as Botones')
                        );
            $response = $response->get();
            return DataTables::of($response)
                    ->make('true'); 
            // return DataTables()->query($response)->toJson();
        }
        
        return view("extranet.configuracion.requisito");
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        try {  

            
            $path = "";
            if(isset($request->archivo)){

                $nombreArchivo = Str::slug($request->nombre,'-').'-'.time().'.pdf';
                $ruta = '/requisitos';
                $path = $ruta."/".$nombreArchivo;
                $archivo = $request->archivo;
    
                Storage::disk('formatos')->putFileAs($ruta, $archivo, $nombreArchivo);
            }

            $data = new Requisito;
            $data->nombre = $request->nombre;
            $data->formato = $request->formato;
            $data->enlace = $path;
            $data->save();

            DB::commit();
            $message = 'Guardado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $response["data"] = DB::table("requisito")
                                ->where("id",$id)
                                ->first();
        return $response;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {  

            $data = Requisito::find($id);
            $data->nombre = $request->nombre;
            $data->save();

            DB::commit();
            $message = 'Editado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Editar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function editar(Request $request, $id)
    {
        // dd($request);
        DB::beginTransaction();
        try {  
            $data = Requisito::find($id);
            $path = "";
            if($request->formato=='1'){
                if(isset($request->archivo)){

                    $nombreArchivo = Str::slug($request->nombre,'-').'-'.time().'.pdf';
                    $ruta = '/requisitos';
                    $path = $ruta."/".$nombreArchivo;
                    $archivo = $request->archivo;
        
                    Storage::disk('formatos')->putFileAs($ruta, $archivo, $nombreArchivo);
                }
            }else{
                Storage::deleteDirectory("formatos".$data->enlace);
            }

            
            $data->nombre = $request->nombre;
            $data->formato = $request->formato;
            $data->enlace = $path;
            $data->save();

            DB::commit();
            $message = 'Editado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Editar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
