<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Proceso;
use App\Models\ProcesoDetalle;
use App\Models\ProcesoRequisito;
use DB;
use DataTables;

class ProcesoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->input('datatable')) {
            $response = DB::table("proceso as p")
                        ->select(
                            "p.id as RowId",
                            "p.nombre as Nombre",
                            DB::raw("CASE 
                                WHEN p.tipo = 0 THEN 'Interno'
                                WHEN p.tipo = 1 THEN 'Tupa'
                                WHEN p.tipo = 2 THEN 'No Tupa'
                                WHEN p.tipo = 3 THEN 'Otro'
                                ELSE 'Otro'
                                END AS TipoExpediente"),
                            "p.tipo as Tipo",
                            "o.nombre as UnidadOrganica",
                            DB::raw('"" as Botones')
                        )
                        ->leftJoin("oficina as o","o.id","p.id_oficina");
                        // ->join("clase as c","c.id","p.id_clase");
            $response = $response->get();
            return DataTables::of($response)
                    ->make('true'); 
            // return DataTables()->query($response)->toJson();
        }
        // $response["clase"] = DB::table("clase")->get();
        // $response["servicio"] = DB::table("servicio")->get();
        $response["oficina"] = DB::table("oficina")->get();
        $response["requisito"] = DB::table("requisito")->get();
        return view("extranet.configuracion.proceso",$response);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        DB::beginTransaction();
        try {  

            $data = new Proceso;
            $data->tipo = $request->tipo_expediente;
            $data->id_oficina = $request->unidad;
            $data->nombre = $request->nombre;
            $data->save();

            DB::commit();
            $message = 'Guardado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $response["data"] = DB::table("proceso")
                                ->where("id",$id)
                                ->first();
        return $response;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        DB::beginTransaction();
        try {  

            $data = Proceso::find($id);
            $data->tipo = $request->tipo_expediente;
            $data->id_oficina = $request->unidad;
            $data->nombre = $request->nombre;
            $data->save();

            DB::commit();
            $message = 'Editado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Editar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    public function proceso(Request $request){
        // dd($request);
        if ($request->input('datatable')) {
            $response = DB::table("proceso_detalle as pd")
                        ->select(
                            "pd.id as RowId",
                            "pd.orden as Orden",
                            "o.nombre as Oficina",
                            DB::raw('"" as Botones')
                        )
                        ->join("oficina as o","o.id","pd.id_oficina");
            if(isset($request->proceso)):
                $response = $response->where('pd.id_proceso',$request->proceso);
            endif;
            $response = $response->get();
            return DataTables::of($response)
                    ->make('true'); 
            // return DataTables()->query($response)->toJson();
        }
    }
    public function requisito(Request $request){
        // dd($request);
        if ($request->input('datatable')) {
            $response = DB::table("proceso_requisito as pr")
                        ->select(
                            "pr.id as RowId",
                            "pr.orden as Orden",
                            DB::raw("CASE 
                                    WHEN pr.tipo = 1 THEN 'Empiezo'
                                    WHEN pr.tipo = 2 THEN 'En Trámite'
                                    WHEN pr.tipo = 3 THEN 'Fisico'
                                    WHEN pr.tipo = 4 THEN 'Requerido'
                                    ELSE ''
                                    END AS Tipo"),
                            "r.nombre as Requisito",
                            DB::raw('"" as Botones')
                        )
                        ->join("requisito as r","r.id","pr.id_requisito");
            if(isset($request->proceso)):
                $response = $response->where('pr.id_proceso',$request->proceso);
            endif;
            $response = $response->get();
            return DataTables::of($response)
                    ->make('true'); 
            // return DataTables()->query($response)->toJson();
        }
    }
    public function proceso_delete($id){
        DB::beginTransaction();
        try {  

            $data = ProcesoDetalle::find($id);
            $data->delete();

            DB::commit();
            $message = 'Eliminado';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Eliminar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function requisito_delete($id){
        DB::beginTransaction();
        try {  

            $data = ProcesoRequisito::find($id);
            $data->delete();

            DB::commit();
            $message = 'Eliminado';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Eliminar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function proceso_store(Request $request,$id){
        // dd($request,$id);
        DB::beginTransaction();
        try {  

            $data =new ProcesoDetalle;
            $data->orden = $request->orden;
            $data->id_proceso = $id;
            $data->id_oficina = $request->oficina;
            $data->save();

            DB::commit();
            $message = 'Guardado';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    public function requisito_store(Request $request,$id){
        // dd($request,$id);
        DB::beginTransaction();
        try {  

            $data =new ProcesoRequisito;
            $data->orden = $request->orden;
            $data->id_proceso = $id;
            $data->id_requisito = $request->requisito;
            $data->tipo = $request->tipo;
            $data->save();

            DB::commit();
            $message = 'Guardado';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Guardar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
