<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\DataTables;
use App\Models\Tramite;
use App\Models\Expediente;
use App\Mail\Seguimiento;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Mail;

class MesaController extends Controller
{
    public function index(Request $request)
    {
        $response["proceso"] = DB::table("proceso")->get();
        
        $response["list_anio"] = DB::table("expediente as e")
                    ->select(
                        DB::raw("YEAR(e.created_at) as anio")
                    )
                    ->orderBy("anio","desc")
                    ->groupBy(DB::raw("YEAR(e.created_at)"))->get();
        return view('extranet.mesa.index',$response);
    }

    public function lista(Request $request)
    {
        $response = DB::table("expediente as e")
                    ->select(
                        "e.id as RowId",
                        "e.asunto as Asunto",
                        "e.solicitud_codigo as SolicitudCodigo",
                        "e.codigo as CodigoExpediente",
                        DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                        // "e.comentario as Comentario",
                        DB::raw("CASE 
                                WHEN e.estado = 0 THEN 'Pendiente'
                                WHEN e.estado = 1 THEN 'En trámite'
                                WHEN e.estado = 2 THEN 'Rechazado'
                                ELSE 'Pendiente'
                                END AS Estado"),
                        "e.estado as NumEstado",
                        DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Entidad"),
                        DB::raw("CASE 
                                WHEN p.tipo = 1 THEN 'Tupa'
                                WHEN p.tipo = 2 THEN 'No Tupa'
                                WHEN p.tipo = 3 THEN 'Otro'
                                ELSE 'Otro'
                                END AS TipoExpediente"),
                        "p.nombre as Proceso",

                        DB::raw('"" as Botones')
                    )
                    ->join("entidad as en","en.id","e.id_entidad")
                    ->join("proceso as p","p.id","e.id_proceso")
                    // ->join("servicio as s","s.id","p.id_servicio")
                    // ->join("clase as c","c.id","p.id_clase")
                    // ->where("e.tipo",0)
                    ->orderBy("e.created_at","desc");
        if(isset($request->estado)):
            $response = $response->where('e.estado',$request->estado);
        endif;
        if(isset($request->tipo_expediente)):
            $response = $response->where('p.tipo',$request->tipo_expediente);
        endif;
        if(isset($request->proceso)):
            $response = $response->where('p.id',$request->proceso);
        endif;
        if(isset($request->anio)):
            $response = $response->where(DB::raw("YEAR(e.created_at)"),$request->anio);
        endif;
        $response = $response->get();
        return DataTables::of($response)
                ->make('true'); 
        // return DataTables()->query($response)->toJson();
    }


    public function revisar($id){
        $id_oficina  = Auth::user()->id_oficina;
    	$response["expediente"] = DB::table("expediente as e")
	            ->select(
	                "e.id as RowId",
	                "e.solicitud_codigo as SolicitudCodigo",
	                "e.codigo as CodigoExpediente",
                    "e.numero_documento as NumeroDocumento",
	                "e.asunto as Asunto",
                    "e.folio as Folio",
                    "e.observacion as Observacion",
	                DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
	                DB::raw("CASE 
	                        WHEN e.estado = 0 THEN 'Pendiente'
	                        WHEN e.estado = 1 THEN 'En tramite'
	                        WHEN e.estado = 2 THEN 'Rechazado'
	                        ELSE 'Pendiente'
	                        END AS Estado"),
	                "e.estado",
                    "e.tipo_entidad as TipoEntidad",
                    
	                "td.nombre as TipoDocumento",
	                DB::raw("CONCAT(en.documento,' | ',en.paterno,' ',en.materno,' ',en.nombres) as Responsable"),
	                "en.telefono as Telefono",
	                "en.email as Email",
	                "en.direccion as Direccion",
	                "en.id_ubigeo as Ubigeo",
                    "en.extranjero as Extranjero",
                    "en.pais as Pais",

                    "em.ruc as Ruc",
                    "em.razon_social as RazonSocial",
                    "em.direccion as DireccionEmpresa",

                    DB::raw("CASE 
                                WHEN p.tipo = 1 THEN 'Tupa'
                                WHEN p.tipo = 2 THEN 'No Tupa'
                                WHEN p.tipo = 3 THEN 'Otro'
                                ELSE 'Otro'
                                END AS TipoExpediente"),
                    "p.nombre as Proceso",
                    "p.tipo as IdTipo",
                    "p.id as IdProceso",

	                DB::raw('"" as Botones')
	            )
	            ->join("entidad as en","en.id","e.id_entidad")
                ->leftJoin("empresa as em","em.id","e.id_empresa")
                ->join("proceso as p","p.id","e.id_proceso")
                // ->join("servicio as s","s.id","p.id_servicio")
                // ->join("clase as c","c.id","p.id_clase")
	            ->join("tipo_documento as td","td.id","en.id_tipo_documento")
	            ->where("e.id",$id)
	            ->first();

        // if($response["expediente"]->Extranjero==0){
            $response['distrito'] = DB::table('ubigeo')
                                ->select('nombre','provincia','departamento')
                                ->where('id',$response["expediente"]->Ubigeo)
                                ->first();

            $response['provincia'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('provincia',$response['distrito']->provincia)
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('distrito','0')
                            ->first();

            $response['departamento'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('provincia','0')
                            ->where('distrito','0')
                            ->first();
        // }
            $response["requisitos"] = DB::table("expediente_requisito as er")
                                    ->select("r.nombre","er.*")
                                    ->leftJoin("requisito as r","r.id","er.id_requisito")
                                    ->where("er.id_expediente",$id)
                                    ->orderby("er.tipo","asc")
                                    // ->orderby("er.observado","desc")
                                    // ->where("ea.tipo",0)
                                    ->get();
        // $response["archivo_resultado"] = DB::table("expediente_archivo as ea")
        //                         ->select("a.nombre","a.enlace","ea.tipo","o.nombre as Oficina")
        //                         ->join("archivo as a","a.id","ea.id_archivo")
        //                         ->join("oficina as o","o.id","a.id_oficina")
        //                         ->where("ea.id_expediente",$id)
        //                         ->where("ea.tipo",2)
        //                         ->get();
        // $oficina = 0;
        if ($response["expediente"]->IdTipo==1) {
            $proceso_detalle = DB::table("proceso_detalle")
                            ->where("id_oficina",$id_oficina)
                            ->where("id_proceso",$response["expediente"]->IdProceso)
                            ->first();

            $next_oficina = DB::table("proceso_detalle as pd")
                            ->select("pd.*","o.nombre as Oficina")
                            ->where("orden",($proceso_detalle->orden+1))
                            ->where("id_proceso",$response["expediente"]->IdProceso)
                            ->join("oficina as o","o.id","pd.id_oficina")
                            ->first();
            // $oficina = $next_oficina;
            $response["oficina"] = $next_oficina;
        }
        // dd($response);
        // dd($response["archivo_solicitante"]);
        return view("extranet.mesa.revisar",$response);
    }
    public function derivar(Request $request,$id){
    	// dd($id);
    	DB::beginTransaction();
        try {  

            $id_users = Auth::user()->id;

            $id_oficina  = Auth::user()->id_oficina;

            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("numero")
                ->where("id_periodo",$periodo->id)
                ->where("estado",1) 
                ->orderBy("numero","desc")
                ->first();

            // dd($query);
                $numero = 1;

            if($query){
                $numero = (int)$query->numero + 1;
            }
            // $periodo = "19";
            $codigo= "E-".$periodo->abrev."-".str_pad($numero, 6, "0", STR_PAD_LEFT);


            $data =Expediente::find($id);
            $data->numero = $numero;
            $data->codigo = $codigo;
            // $data->observacion = $request->observacion;
           	$data->estado = 1;
           	$data->id_users = $id_users;
            $data->save();

            // dd($data);
            // $proceso_detalle = DB::table("proceso_detalle")
            //                 ->where("id_oficina",$id_oficina)
            //                 ->where("id_proceso",$data->id_proceso)
            //                 ->first();

            // $next_oficina = DB::table("proceso_detalle")
            //                 ->where("orden",($proceso_detalle->orden+1))
            //                 ->where("id_proceso",$data->id_proceso)
            //                 ->first();

            $newtramite = new Tramite;
            $newtramite->id_expediente = $id;
            $newtramite->id_oficina = $id_oficina;
            $newtramite->id_oficina_destino = $request->oficina;
            $newtramite->observacion = $request->observacion;
            $newtramite->estado = 2;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            $newtramite = new Tramite;
            $newtramite->id_expediente = $id;
            $newtramite->id_oficina = $request->oficina;
            $newtramite->observacion = $request->observacion;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            $entidad = DB::table("expediente as e")
                    ->select("en.*")
                    ->join("entidad as en","en.id","e.id_entidad")
                    ->where("e.id",$id)
                    ->first();
            try {
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["estado"] = "Derivado";
                $mensaje["observacion"] = $request->observacion;
                $mensaje["expediente"] = Crypt::encryptString($id);
                Mail::to($entidad->email)->send(new Seguimiento($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }
            
            DB::commit();
            $message = 'Expediente Derivado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Derivar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    public function rechazar(Request $request,$id){

        DB::beginTransaction();
        try {
            $id_users  = Auth::user()->id;

            $expediente = Expediente::find($id);
            $expediente->estado = 2;
            $expediente->observacion = $request->observacion;
            $expediente->id_users = $id_users;
            $expediente->save();

            $entidad = DB::table("expediente as e")
                    ->select("en.*")
                    ->join("entidad as en","en.id","e.id_entidad")
                    ->where("e.id",$id)
                    ->first();
            $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
            $mensaje["estado"] = "Rechazado";
            $mensaje["observacion"] = $request->observacion;
            $mensaje["expediente"] = Crypt::encryptString($id);
            Mail::to($entidad->email)->send(new Seguimiento($mensaje));

        DB::commit();
            $message = 'Rechazado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al rechazar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }
}
