<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\DataTables;
use App\Models\Expediente;
use App\Models\ExpedienteArchivo;
use App\Models\Tramite;
use App\Models\Archivo;
use App\Models\Adjunto;
use App\Models\ExpedienteAdjunto;
use Illuminate\Support\Str;

class InternoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // dd($id_oficina);
        // if ($request->input('datatable')) {

        //     $id_oficina = Auth::user()->id_oficina;

        //     $response = DB::table("expediente as e")
        //                 ->select(
        //                     "e.id as RowId",
        //                     "e.codigo as CodigoExpediente",
        //                     "e.numero_expediente as NumeroExpediente",
        //                     DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
        //                     "e.asunto as Asunto",
        //                     "e.comentario as Comentario",
        //                     DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Responsable"),

        //                     DB::raw('"" as Botones')
        //                 )
        //                 ->join("entidad as en","en.id","e.id_entidad")
        //                 ->leftJoin("expediente_tipo as et","et.id","e.id_expediente_tipo")
        //                 ->where("e.id_oficina",$id_oficina);
        //     if(isset($request->estado)):
        //         $response = $response->where('e.estado',$request->estado);
        //     endif;
        //     // $response = $response->get();
        //     // return DataTables::of($response)
        //     //         ->make('true'); 
        //     return DataTables()->query($response)->toJson();
        // }
        return view('extranet.expediente.interno.index');
    }

    public function lista(Request $request){
        $id_oficina = Auth::user()->id_oficina;

        $response = DB::table("expediente as e")
                    ->select(
                        "e.id as RowId",
                        "e.codigo as CodigoExpediente",
                        "e.numero_documento as NumeroDocumento",
                        DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                        "e.asunto as Asunto",
                        "e.observacion as Observacion",
                        // DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Responsable"),

                        DB::raw('"" as Botones')
                    )
                    // ->join("entidad as en","en.id","e.id_entidad")
                    // ->leftJoin("expediente_tipo as et","et.id","e.id_expediente_tipo")
                    ->where("e.id_oficina",$id_oficina);
        if(isset($request->estado)):
            $response = $response->where('e.estado',$request->estado);
        endif;
        return DataTables::of($response->get())
        ->make('true'); 
        // return DataTables()->query($response)->toJson();
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    
    public function create()
    {
        $response["proceso"] = DB::table("proceso")
                            ->where("tipo",0)
                            ->get();
        return view("extranet.expediente.interno.create",$response);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        DB::beginTransaction();
        try {  

            // $id_entidad = Auth::user()->oficina->id_entidad;
            $id_oficina = Auth::user()->oficina->id;
            // $abrv_oficina = Auth::user()->oficina->abrev;

            // $tipo = DB::table("expediente_tipo")
            //     ->where("id",$request->expediente_tipo)
            //     ->first();

            // $abrv_tipo = $tipo->abrev;

            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("numero")
                ->where("id_periodo",$periodo->id)
                ->where("id_oficina",$id_oficina)
                // ->where("id_expediente_tipo",$request->expediente_tipo)
                ->where("tipo",2)
                ->orderBy("numero","desc")
                ->first();
                $numero = 1;

            if($query){
                $numero = (int)$query->numero + 1;
            }
            // $periodo = "19";
            $codigo= "I-".str_pad($id_oficina, 2, "0", STR_PAD_LEFT)."-".str_pad($numero, 4, "0", STR_PAD_LEFT)."-".$periodo->nombre;

            // dd($codigo);


            $data = new Expediente;
            $data->numero = $numero;
            $data->codigo = $codigo;
            $data->numero_documento = $request->n_documento;
            $data->id_proceso = $request->proceso;
            $data->folio = $request->n_folio;
            $data->asunto = $request->asunto;
            $data->observacion = $request->observacion_expediente;
            $data->tipo = 2;
            // $data->fecha_reg = date("Y-m-d");
            $data->id_periodo = $periodo->id;
            // $data->id_entidad = $id_entidad;
            $data->id_oficina = $id_oficina;
            $data->save();

            $id = $data->id;

            $tramite = new Tramite;
            $tramite->id_expediente = $id;
            $tramite->id_oficina = $id_oficina;
            $tramite->id_oficina_destino = $request->oficina;
            $tramite->observacion = $request->observacion;
            $tramite->estado = 2;
            $tramite->fecha_estado = date("Y-m-d H:i:s");
            $tramite->save();

            $newtramite = new Tramite;
            $newtramite->id_expediente = $id;
            $newtramite->id_oficina = $request->oficina;
            $newtramite->observacion = $request->observacion;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            if(isset($request->copia)){
                foreach ($request->copia as $key => $value) {
                    $copia = new Tramite;
                    $copia->id_expediente = $id;
                    $copia->id_oficina = $id_oficina;
                    $copia->id_oficina_destino = $value;
                    $copia->observacion ="Copia - ".$request->observacion;
                    $copia->fecha_estado = date("Y-m-d H:i:s");
                    $copia->estado = 2;
                    $copia->copia = 1;
                    $copia->save();

                    $newcopia = new Tramite;
                    $newcopia->id_expediente = $id;
                    $newcopia->id_oficina = $value;
                    $newcopia->observacion ="Copia - ".$request->observacion;
                    $newcopia->fecha_estado = date("Y-m-d H:i:s");
                    $newcopia->copia = 1;
                    $newcopia->save();
                }
            }

            try {
                
                if(isset($request->archivo)){
                    $nombre = $request->archivo->getClientOriginalName();
                    $nombreArchivo = Str::slug($nombre ,'-').'-'.time().'.pdf';
                    $ruta = '/interno/'.date('Y').'/'.date("m").'/'.date("d").'/'.$id_oficina;
                    $path = $ruta."/".$nombreArchivo;
                    $archivo = $request->archivo;
    
                    Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);
                }
                // if($request->file("archivo")){
                    // $doc = $request->file("archivo");
                    // $name = $doc->getClientOriginalName();
                    // $slug = Str::slug($name,' ');

                    // $nombre = strtotime("now")."-".$slug.".".$doc->getClientOriginalExtension();

                    // $ruta = '/documentos/expedientes/interno/'.$id_oficina.'/'.$periodo->nombre.'/'.$request->expediente_tipo.'/';
                    // $destino = public_path($ruta);
                    // $succ = $doc->move($destino,$nombre);

                    $archivo = new Adjunto;
                    // $archivo->id_expediente = $id;
                    $archivo->nombre = $nombre;
                    $archivo->enlace = $path;
                    $archivo->id_oficina = $id_oficina;
                    $archivo->save();
        
                    $expe_archivo1 = new ExpedienteAdjunto;
                    $expe_archivo1->id_adjunto = $archivo->id;
                    $expe_archivo1->id_expediente = $data->id;
                    $expe_archivo1->save();
        
                    // $expe_archivo2 = new ExpedienteAdjunto;
                    // $expe_archivo2->id_adjunto = $archivo->id;
                    // $expe_archivo2->id_expediente = $id;
                    // $expe_archivo2->save();

                    // $archivo = new Archivo;
                    // // $archivo->id_expediente = $id;
                    // $archivo->nombre = $slug;
                    // $archivo->enlace = $ruta.$nombre;
                    // $archivo->tipo = 0;
                    // $archivo->id_oficina = $id_oficina;
                    // $archivo->save();

                    // $expe_archivo = new ExpedienteArchivo;
                    // $expe_archivo->id_archivo = $archivo->id;
                    // $expe_archivo->id_expediente = $id;
                    // $expe_archivo->tipo = 0;
                    // $expe_archivo->save();

                // }
                    
            } catch (\Exception $e) {
                DB::rollback();
                $message = 'Archivos no Subidos.';
                $status = false;

                $response["status"] = $status;
                $response["message"] = $message;
                return $response;
            } 

            DB::commit();
            $message = 'Expediente Creado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Crear Expediente. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // dd($id);
        $response["expediente"] = DB::table("expediente as e")
                ->select(
                    "e.id as RowId",
                    "e.codigo as CodigoExpediente",
                    "e.numero_documento as NumeroDocumento",
                    DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                    "e.asunto as Asunto",
                    "e.folio as Folio",
                    // "e.observacion as Observacion",
                    // "e.archivo as Archivo",
                    DB::raw("CASE 
                            WHEN e.estado = 0 THEN 'Pendiente'
                            WHEN e.estado = 1 THEN 'En tramite'
                            WHEN e.estado = 2 THEN 'Rechazado'
                            ELSE 'Pendiente'
                            END AS Estado"),
                    "e.estado",
                    "e.observacion as Observacion",

                    // DB::raw("CASE 
                    //         WHEN en.tipo = 0 THEN 'Persona Natural'
                    //         WHEN en.tipo = 1 THEN 'Persona Juridica'
                    //         ELSE ''
                    //         END AS TipoPersona"),
                    // "en.tipo",
                    // "td.nombre as TipoDocumento",
                    // DB::raw("CONCAT(en.documento,' | ',IFNULL(en.paterno,''),' ',IFNULL(en.materno,''),' ',IFNULL(en.nombres,'')) as Responsable"),
                    // "en.telefono as Telefono",
                    // "en.email as Email",
                    // "en.direccion as Direccion",
                    // "en.id_ubigeo as Ubigeo",
                    // DB::raw("CONCAT(em.ruc,' | ',em.empresa) as Empresa"),
                    // "em.direccion as DireccionEmpresa",

                    DB::raw('"" as Botones')
                )
                // ->join("entidad as en","en.id","e.id_entidad")
                // ->leftJoin("empresa as em","em.id","en.id_empresa")
                // ->join("tipo_documento as td","td.id","en.id_tipo_documento")
                // ->leftJoin("expediente_tipo as et","et.id","e.id_expediente_tipo")
                ->where("e.id",$id)
                ->first();

        // $response['distrito'] = DB::table('ubigeo')
        //                     ->select('nombre','provincia','departamento')
        //                     ->where('id',$response["expediente"]->Ubigeo)
        //                     ->first();

        // $response['provincia'] = DB::table('ubigeo')
        //                 ->select('nombre')
        //                 ->where('provincia',$response['distrito']->provincia)
        //                 ->where('departamento',$response['distrito']->departamento)
        //                 ->where('distrito','0')
        //                 ->first();

        // $response['departamento'] = DB::table('ubigeo')
        //                 ->select('nombre')
        //                 ->where('departamento',$response['distrito']->departamento)
        //                 ->where('provincia','0')
        //                 ->where('distrito','0')
        //                 ->first();
        $response["adjuntos"] = DB::table("expediente_adjunto as ea")
                        ->select("a.*","o.nombre as Oficina")
                        ->join("adjunto as a","a.id","ea.id_adjunto")
                        ->join("oficina as o","o.id","a.id_oficina")
                        ->where("ea.id_expediente",$id)
                        ->get();
        // $response["archivo_resultado"] = DB::table("expediente_archivo as ea")
        //                         ->select("a.nombre","a.enlace","ea.tipo","o.nombre as Oficina")
        //                         ->join("archivo as a","a.id","ea.id_archivo")
        //                         ->join("oficina as o","o.id","a.id_oficina")
        //                         ->where("ea.id_expediente",$id)
        //                         ->where("ea.tipo",2)
        //                         ->get();

        // dd($response);
        return view("extranet.expediente.interno.show",$response);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
