<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Storage;
use App\Models\Expediente;
use App\Models\ExpedienteArchivo;
use App\Models\ExpedienteRequisito;
use App\Models\Tramite;
use App\Models\Archivo;
use App\Models\Entidad;
use App\Models\Proceso;
use App\Models\Empresa;
use Illuminate\Support\Str;
use Illuminate\Support\Arr;
use PDF;

class ExternoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('extranet.expediente.externo.index');
    }
    public function lista(Request $request){
        $id_oficina = Auth::user()->id_oficina;

        $response = DB::table("expediente as e")
                    ->select(
                        "e.id as RowId",
                        "e.codigo as CodigoExpediente",
                        "e.numero_documento as NumeroDocumento",
                        DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                        "e.asunto as Asunto",
                        "e.observacion as Observacion",
                        // DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Responsable"),

                        DB::raw('"" as Botones')
                    )
                    // ->join("entidad as en","en.id","e.id_entidad")
                    // ->leftJoin("expediente_tipo as et","et.id","e.id_expediente_tipo")
                    ->where("e.tipo",1);
        if(isset($request->estado)):
            $response = $response->where('e.estado',$request->estado);
        endif;
        return DataTables::of($response->get())
        ->make('true'); 
        // return DataTables()->query($response)->toJson();
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        // $response["tipo"] = DB::table("expediente_tipo")
        //                     ->where("tipo",1)
        //                     ->get();
        return view("extranet.expediente.externo.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $id_oficina = Auth::user()->oficina->id;
        DB::beginTransaction();
        try {
            $periodo = DB::table("periodo")
                ->where("estado",1)
                ->orderBy("id","desc")
                ->first();

            $query = DB::table("expediente")
                ->select("solicitud_numero")
                ->where("id_periodo",$periodo->id)
                ->orderBy("solicitud_numero","desc")
                ->first();
            $numero = 1;

            if($query){
                $numero = (int)$query->solicitud_numero + 1;
            }
            $codigo= "S-".$periodo->abrev."-".str_pad($numero, 6, "0", STR_PAD_LEFT);

            $query_expediente = DB::table("expediente")
                ->select("numero")
                ->where("id_periodo",$periodo->id)
                ->where("estado",1) 
                ->orderBy("numero","desc")
                ->first();

            // dd($query_expediente);
                $numero_expediente = 1;

            if($query_expediente){
                $numero_expediente = (int)$query_expediente->numero + 1;
            }
            // $periodo = "19";
            $codigo_expediente = "E-".$periodo->abrev."-".str_pad($numero_expediente, 6, "0", STR_PAD_LEFT);


            $persona = DB::table("entidad")
                        ->where("documento",$request->documento)
                        ->first();
            $empresa = NULL;
            if($request->tipo_persona == '1'){
                $query_empresa = DB::table("empresa")
                        ->where("ruc",$request->ruc)
                        ->first();
                if($query_empresa){
                    $empresa = $query_empresa->id;
                }else{
                    $new_empresa = new Empresa;
                    $new_empresa->ruc = $request->ruc;
                    $new_empresa->razon_social = $request->razon_social;
                    $new_empresa->direccion = $request->direccion_empresa;
                    $new_empresa->save();
                    $empresa = $new_empresa->id;
                }
            }

            if($persona){
                $entidad = Entidad::find($persona->id);
                $entidad->telefono = $request->telefono;
                $entidad->email = $request->email;
                $entidad->direccion = $request->direccion;
                // if(isset($request->distrito)){
                $entidad->id_ubigeo = $request->distrito;
                // }
                // if(isset($request->pais)){
                //     $entidad->pais = $request->pais;
                // }
                // $entidad->id_empresa = $empresa;
                $entidad->save();
            }else{
                $entidad = new Entidad;
                $entidad->documento = $request->documento;
                $entidad->paterno = $request->paterno;
                $entidad->materno = $request->materno;
                $entidad->nombres = $request->nombres;
                $entidad->telefono = $request->telefono;
                $entidad->email = $request->email;
                $entidad->direccion = $request->direccion;
                $entidad->id_tipo_documento = 1;
                $entidad->id_ubigeo = $request->distrito;
                // $entidad->id_empresa = $empresa;
                $entidad->save();
            }


            $array = [1,2,3,4,5,6,7,8,9,0];
            $password = Arr::random($array).Arr::random($array).Arr::random($array).Arr::random($array);
            
            $asunto = "";
            $setOficina = NULL;
            switch ($request->tipo_expediente) {
                case '1':
                    $proceso = Proceso::find($request->proceso);
                    $asunto = $proceso->nombre;
                    $setOficina = $proceso->id_oficina;    
                    break;
                case '2':
                    // $proceso = Proceso::find($request->proceso);
                    $setOficina = $request->oficina;    
                    $asunto = $request->asunto;
                    break;
                case '3':
                    $setOficina = $request->oficina;    
                    $asunto = $request->asunto;
                    break;
                default:
                    $asunto = "";
                    break;
            }
            // $random = Arr::random($array);
            $expediente = new Expediente;
            $expediente->solicitud_numero = $numero;
            $expediente->solicitud_codigo = $codigo;
            $expediente->numero = $numero_expediente;
            $expediente->codigo = $codigo_expediente;
            $expediente->asunto = $asunto;
            $expediente->numero_documento = $request->n_documento;
            $expediente->folio = $request->folio;
            $expediente->estado = 1;
            $expediente->observacion = $request->observacion;
            // $expediente->numero_voucher = $request->numero;
            // $expediente->fecha_estado = date("Y-m-d H:i:s");
            $expediente->password = $password;
            $expediente->id_periodo = $periodo->id;
            $expediente->id_proceso = $request->proceso;
            $expediente->id_entidad = $entidad->id;
            $expediente->id_empresa = $empresa;
            $expediente->tipo_entidad = $request->tipo_persona;
            $expediente->save();

            if(isset($request->archivo)){

                foreach ($request->archivo as $key => $value) {
                    // $ids = explode("-",$key);
                    // var_dump($ids);
                    $req = DB::table("proceso_requisito as pr")
                            ->select("r.id","pr.orden","pr.tipo","r.nombre")
                            ->join("requisito as r","r.id","pr.id_requisito")
                            ->where("pr.id",$key)
                            ->first();
                        $nombreArchivo = Str::slug($req->nombre,'-').'-'.time().'.pdf';
                        $ruta = '/'.date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                        $path = $ruta."/".$nombreArchivo;
                        $archivo = $value;
                        
                        Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);

                        $requisito = new ExpedienteRequisito;
                        $requisito->enlace = $path;
                        $requisito->id_requisito = $req->id;
                        $requisito->id_expediente = $expediente->id;
                        $requisito->tipo = $req->tipo;
                        $requisito->estado = 1;
                        $requisito->save();
                }
            }
            if(isset($request->adjunto)){

                foreach ($request->adjunto as $key => $value) {
                    // $ids = explode("-",$key);
                    // var_dump($ids);
                    // $req = DB::table("proceso_requisito as pr")
                    //         ->select("r.id","pr.orden","pr.tipo","r.nombre")
                    //         ->join("requisito as r","r.id","pr.id_requisito")
                    //         ->where("pr.id",$key)
                    //         ->first();
                    $nombreArchivo = Str::slug($value->getClientOriginalName(),'-').'-'.time().'.pdf';
                    #$ruta = '/'.date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                    $ruta = date('Y').'/'.date("m").'/'.date("d").'/'.$entidad->documento;
                    $path = $ruta."/".$nombreArchivo;
                    $archivo = $value;        
                    Storage::disk('expediente')->putFileAs($ruta, $archivo, $nombreArchivo);
                    $requisito = new ExpedienteRequisito;
                    $requisito->enlace = $path;
                    // $requisito->id_requisito = $req->id;
                    $requisito->id_expediente = $expediente->id;
                    $requisito->tipo = $req->tipo;
                    $requisito->estado = 1;
                    $requisito->save();
                }
            }

            $newtramite = new Tramite;
            $newtramite->id_expediente = $expediente->id;
            $newtramite->id_oficina = $id_oficina;
            $newtramite->id_oficina_destino = $setOficina;
            // $newtramite->observacion = $request->observacion;
            $newtramite->estado = 2;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            $newtramite = new Tramite;
            $newtramite->id_expediente = $expediente->id;
            $newtramite->id_oficina = $setOficina;
            // $newtramite->observacion = $request->observacion;
            $newtramite->fecha_estado = date("Y-m-d H:i:s");
            $newtramite->save();

            try {
                $mensaje["responsable"] = $entidad->documento." | ".$entidad->paterno." ".$entidad->materno." ".$entidad->nombres;
                $mensaje["codigo"] = $expediente->solicitud_codigo;
                $mensaje["password"] = $expediente->password;
                Mail::to($entidad->email)->send(new Mensaje($mensaje));
            } catch (\Throwable $th) {
                //throw $th;
            }

            DB::commit();
            $response["id"] = $expediente->id;
            $message = 'Registrado.';
            $status = true;
        } catch (\Exception $e) {
            DB::rollback();
            $message = 'Error al Registrar. Intente otra vez.';
            $status = false;
        }
        $response["status"] = $status;
        $response["message"] = $message;
        return $response;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $response["expediente"] = DB::table("expediente as e")
	            ->select(
	                "e.id as RowId",
	                "e.codigo as CodigoExpediente",
	                "e.solicitud_codigo as SolicitudCodigo",
                    "e.numero_documento as NumeroDocumento",
	                "e.asunto as Asunto",
                    "e.folio as Folio",
                    "e.observacion as Observacion",
	                // "e.numero_expediente as NumeroDocumento",
	                DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),

                    DB::raw("CASE 
	                        WHEN e.estado = 0 THEN 'Pendiente'
	                        WHEN e.estado = 1 THEN 'En tramite'
	                        WHEN e.estado = 2 THEN 'Rechazado'
	                        ELSE 'Pendiente'
	                        END AS Estado"),
	                "e.estado",
                    "e.tipo_entidad as TipoEntidad",

                    DB::raw("CASE 
	                        WHEN e.tipo = 1 THEN 'Externo'
	                        WHEN e.tipo = 2 THEN 'Interno'
	                        ELSE 'Interno'
	                        END AS Tipo"),

	                "td.nombre as TipoDocumento",
	                DB::raw("CONCAT(en.documento,' | ',IFNULL(en.paterno,''),' ',IFNULL(en.materno,''),' ',IFNULL(en.nombres,'')) as Responsable"),
	                "en.telefono as Telefono",
	                "en.email as Email",
	                "en.direccion as Direccion",
	                "en.id_ubigeo as Ubigeo",
                    "en.extranjero as Extranjero",
                    "en.pais as Pais",

                    "em.ruc as Ruc",
                    "em.razon_social as RazonSocial",
                    "em.direccion as DireccionEmpresa",

                    DB::raw("CASE 
                        WHEN p.tipo = 1 THEN 'Tupa'
                        WHEN p.tipo = 2 THEN 'No Tupa'
                        WHEN p.tipo = 3 THEN 'Otro'
                        ELSE 'Otro'
                        END AS TipoExpediente"),
                    "p.nombre as Proceso",
                    "p.tipo as IdTipo",
                    "p.id as IdProceso",
	                // DB::raw("CONCAT(em.ruc,' | ',em.empresa) as Empresa"),
	                "o.nombre as Oficina",

	                DB::raw('"" as Botones')
	            )
	            ->leftJoin("entidad as en","en.id","e.id_entidad")
                ->leftJoin("empresa as em","em.id","e.id_empresa")
                ->leftJoin("oficina as o","o.id","e.id_oficina")
                // ->leftJoin("empresa as em","em.id","en.id_empresa")
	            ->leftJoin("tipo_documento as td","td.id","en.id_tipo_documento")
	            ->join("proceso as p","p.id","e.id_proceso")
	            ->where("e.id",$id)
	            ->first();
        // dd($response);
        if(isset($response["expediente"]->Ubigeo)){
            $response['distrito'] = DB::table('ubigeo')
                                ->select('nombre','provincia','departamento')
                                ->where('id',$response["expediente"]->Ubigeo)
                                ->first();

            $response['provincia'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('provincia',$response['distrito']->provincia)
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('distrito','0')
                            ->first();

            $response['departamento'] = DB::table('ubigeo')
                            ->select('nombre')
                            ->where('departamento',$response['distrito']->departamento)
                            ->where('provincia','0')
                            ->where('distrito','0')
                            ->first();
        }
        $response["requisitos"] = DB::table("expediente_requisito as er")
                        ->select("r.nombre","er.*")
                        ->leftJoin("requisito as r","r.id","er.id_requisito")
                        ->where("er.id_expediente",$id)
                        ->orderby("er.tipo","asc")
                        // ->where("ea.tipo",0)
                        ->get();            
        $response["adjuntos"] = DB::table("expediente_adjunto as ea")
                        ->select("a.*","o.nombre as Oficina")
                        ->join("adjunto as a","a.id","ea.id_adjunto")
                        ->join("oficina as o","o.id","a.id_oficina")
                        ->where("ea.id_expediente",$id)
                        ->get();  
        // $response["archivo_resultado"] = DB::table("expediente_archivo as ea")
        //                         ->select("a.nombre","a.enlace","ea.tipo","o.nombre as Oficina")
        //                         ->join("archivo as a","a.id","ea.id_archivo")
        //                         ->join("oficina as o","o.id","a.id_oficina")
        //                         ->where("ea.id_expediente",$id)
        //                         ->where("ea.tipo",2)
        //                         ->get();

        // dd($response);
        return view("extranet.expediente.externo.show",$response);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function imprimir($id){
        // $custom_layout = array(20, 20);

        // $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, $custom_layout, true, 'UTF-8', false);
        $query = DB::table("expediente")
                ->where("id",$id)
                ->first();
        $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $pdf::SetDisplayMode('fullpage', 'SinglePage', 'UseNone');
        $pdf::AddPage('L', 'A7');
        $pdf::setPage(1, true);
        $pdf::SetY(40);
        $pdf::Cell(0, 0, $query->codigo, 1, 1, 'C');
        $pdf::lastPage();
        $pdf::Output('Lista.pdf', 'I');
        return false;
    }
}
