<?php

namespace App\Http\Controllers\Extranet;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\DataTables;
use PDF;

class ExpedienteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->input('datatable')) {
            $response = DB::table("expediente as e")
                        ->select(
                            "e.id as RowId",
                            "e.solicitud_codigo as SolicitudCodigo",
                            "e.codigo as CodigoExpediente",
                            DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y %h:%i %p') as FechaReg"),
                            // "e.comentario as Comentario",
                            DB::raw("CASE 
                                    WHEN e.estado = 0 THEN 'Pendiente'
                                    WHEN e.estado = 1 THEN 'En trámite'
                                    WHEN e.estado = 2 THEN 'Rechazado'
                                    ELSE 'Pendiente'
                                    END AS Estado"),
                            "e.estado as NumEstado",
                            DB::raw("CONCAT(en.documento,'|',en.paterno,' ',en.nombres) as Entidad"),
                            "s.nombre as Servicio",
                            "c.nombre as Clase",

                            DB::raw('"" as Botones')
                        )
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->join("proceso as p","p.id","e.id_proceso")
                        ->join("servicio as s","s.id","p.id_servicio")
                        ->join("clase as c","c.id","p.id_clase")
                        // ->where("e.tipo",0)
                        ->orderBy("e.created_at","desc");
            if(isset($request->estado)):
                $response = $response->where('e.estado',$request->estado);
            endif;
            if(isset($request->servicio)):
                $response = $response->where('p.id_servicio',$request->servicio);
            endif;
            if(isset($request->fecha_ini)):
                $response = $response->whereBetween(DB::raw('DATE_FORMAT(e.created_at,"%Y-%m-%d")'),[$request->fecha_ini,$request->fecha_fin]);
            endif;
            $response = $response->get();
            return DataTables::of($response)
                    ->make('true'); 
        }

        $response["servicio"] = DB::table("servicio")->get();
        $response["clase"] = DB::table("clase")->get();
        return view('extranet.expediente.index',$response);
    }
    public function reporte(Request $request){
        $response = DB::table("expediente as e")
                        ->select(
                            "e.id as RowId",
                            "e.solicitud_codigo as SolicitudCodigo",
                            "e.codigo as CodigoExpediente",
                            DB::raw("DATE_FORMAT(e.created_at,'%d/%m/%Y') as FechaReg"),
                            // "e.comentario as Comentario",
                            DB::raw("CASE 
                                    WHEN e.estado = 0 THEN 'Pendiente'
                                    WHEN e.estado = 1 THEN 'En trámite'
                                    WHEN e.estado = 2 THEN 'Rechazado'
                                    ELSE 'Pendiente'
                                    END AS Estado"),
                            "e.estado as NumEstado",
                            DB::raw("CONCAT(en.paterno,' ',en.nombres) as Entidad"),
                            "en.documento as Documento",
                            "s.nombre as Servicio",
                            "c.nombre as Clase"
                        )
                        ->join("entidad as en","en.id","e.id_entidad")
                        ->join("proceso as p","p.id","e.id_proceso")
                        ->join("servicio as s","s.id","p.id_servicio")
                        ->join("clase as c","c.id","p.id_clase")
                        // ->where("e.tipo",0)
                        ->orderBy("e.created_at","desc");
            if(isset($request->estado)):
                $response = $response->where('e.estado',$request->estado);
            endif;
            if(isset($request->servicio)):
                $response = $response->where('p.id_servicio',$request->servicio);
            endif;
            if(isset($request->fecha_ini)):
                $response = $response->whereBetween(DB::raw('DATE_FORMAT(e.created_at,"%Y-%m-%d")'),[$request->fecha_ini,$request->fecha_fin]);
            endif;
            $response = $response->get();
        // dd($response);
        $pdf = new PDF();
        $pdf::SetMargins(10, 35, 10);
        // $subtitulo = "Gerencia de TRansportes";
        //$pdf::SetTitle('Solicitud');
        PDF::setFooterCallback(function($pdf){
            $pdf->SetY(-15);
            $pdf->SetFont('helvetica', 'I', 8);
            $pdf->Cell(0, 10, 'Pagina '.$pdf->getAliasNumPage().'/'.$pdf->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
        });
        PDF::setHeaderCallback(function($pdf) {
            $pdf->SetY(5);
            // $pdf->Image('images/UNAPUNO.png', 10, 4, 20, 20, 'PNG', '', '', true, 150, '', false, false, 0, false, false, false);
            $pdf->SetFont('helvetica', 'b', 12);

            $pdf->Cell(0, 7, 'GERENCIA REGIONAL DE TRANSPORTES Y COMUNICACIONES - CUSCO', 0, 1, 'C', 0, '', 0);
            $pdf->SetFont('helvetica', 'b', 10);
            $pdf->Cell(0, 7, "GOBIERNO REGIONAL DE CUSCO", 0, 1, 'C', 0, '', 0);
            $pdf->SetFont('helvetica', '', 9);
            $pdf->Cell(0,7, 'LISTADO DE EXPEDIENTES', 0, 1, 'C', 0, '', 0);
            // $pdf->SetY(35);
            $pdf->Line(10,27,200,27);
        });
        $pdf::AddPage();
        $y = $pdf::GetY();
        $pdf::SetY($y);
        // $pdf::SetMargins(5, 100, 5);
        $pdf::ln();
        $pdf::SetFont('helvetica', '', 9);
        $tabla = '
                <table cellspacing="0" cellpadding="2" border="1">
                    <thead>
                        <tr style="font-weight: bold;">
                            <td width="24"  align="center">N°</td>
                            <td width="76"  align="center">Cod.Expediente</td>
                            <td width="70"  align="center">Servicio</td>
                            <td width="50"  align="center">Clase</td>
                            <td width="75"  align="center">Fecha</td>
                            <td width="60"  align="center">Documento</td>
                            <td width="130"  align="center">Apellidos y Nombres</td>
                            <td width="55"  align="center">Estado</td>
                        </tr>
                    </thead>';
        foreach ($response as $key => $value) {
            $tabla.='<tr>
                    <td width="24"  align="center">'.($key+1).'</td>
                    <td width="76"  align="center">'.$value->CodigoExpediente.'</td>
                    <td width="70"  align="center">'.$value->Servicio.'</td>
                    <td width="50"  align="center">'.$value->Clase.'</td>
                    <td width="75"  align="center">'.$value->FechaReg.'</td>
                    <td width="60"  align="center">'.$value->Documento.'</td>
                    <td width="130"  align="center">'.$value->Entidad.'</td>
                    <td width="55"  align="center">'.$value->Estado.'</td>
                </tr> ';
        }
        $tabla.='</table>';
        $pdf::writeHTML($tabla, true, false, true, false, 'C');
        $pdf::ln();
        // foreach($datos as $key => $value){
        //     if($carrera==$value->CodCar){
        //         if($tipo == $value->IdTipoTramite){
        //             $tabla.='<tr>
        //                         <td width="24"  align="center">'.($key+1).'</td>
        //                         <td width="76"  align="center">'.$value->CodigoCarrera.'</td>
        //                         <td width="200"  align="center">'.$value->Paterno.' '.$value->Materno.' '.$value->Nombres.'</td>
        //                         <td width="95"  align="center">'.$value->FechaTramite.'</td>
        //                         <td width="100"  align="center">'.$value->Elaboracion.'</td>
        //                         <td width="45"  align="center">'.($value->Tipo==""?'Físico':'Digital').'</td>
        //                     </tr> ';

        //         }else{
        //             if($key!=0){
        //                 $tabla.='</table>';
        //                 $pdf::writeHTML($tabla, true, false, true, false, 'C');
        //                 $pdf::ln();
        //             }
        //             $pdf::SetFont('helvetica', 'b', 10);
        //             $pdf::Cell(0, 5, $value->TipoTramite, 0, 1, 'L', 0, '', 0);
        //             $pdf::ln();

        //             $pdf::SetFont('helvetica', '', 9);
        //             $tabla = '
        //             <table cellspacing="0" cellpadding="2" border="1">
        //                 <thead>
        //                     <tr style="font-weight: bold;">
        //                         <td width="24"  align="center">N°</td>
        //                         <td width="76"  align="center">Cod. Matrícula</td>
        //                         <td width="200"  align="center">Apellidos y Nombres</td>
        //                         <td width="95"  align="center">Fecha de Ingreso del Trámite</td>
        //                         <td width="100"  align="center">N° de INF. y fecha de elaboración (ORAA)</td>
        //                         <td width="45"  align="center">Tipo</td>
        //                     </tr>
        //                 </thead>';
        //             $tabla.='<tr>
        //                 <td width="24"  align="center">'.($key+1).'</td>
        //                 <td width="76"  align="center">'.$value->CodigoCarrera.'</td>
        //                 <td width="200"  align="center">'.$value->Paterno.' '.$value->Materno.' '.$value->Nombres.'</td>
        //                 <td width="95"  align="center">'.$value->FechaTramite.'</td>
        //                 <td width="100"  align="center">'.$value->Elaboracion.'</td>
        //                 <td width="45"  align="center">'.($value->Tipo==""?'Fisico':'Digital').'</td>
        //             </tr> ';
        //         }
        //     }else{
        //         if($key!=0){
        //             $tabla.='</table>';
        //             $pdf::writeHTML($tabla, true, false, true, false, 'C');
        //             $pdf::ln();
        //         }
        //         $pdf::SetFont('helvetica', 'b', 12);
        //         $pdf::Cell(0, 5, $value->EscuelaProfesional, 0, 1, 'C', 0, '', 0);
        //         $pdf::ln();
        //         $pdf::SetFont('helvetica', 'b', 10);
        //         $pdf::Cell(0, 5, $value->TipoTramite, 0, 1, 'L', 0, '', 0);
        //         $pdf::ln();

        //         $pdf::SetFont('helvetica', '', 9);
        //         $tabla = '
        //         <table cellspacing="0" cellpadding="2" border="1">
        //             <thead>
        //                 <tr style="font-weight: bold;">
        //                     <td width="24"  align="center">N°</td>
        //                     <td width="76"  align="center">Cod. Matrícula</td>
        //                     <td width="200"  align="center">Apellidos y Nombres</td>
        //                     <td width="95"  align="center">Fecha de Ingreso del Trámite</td>
        //                     <td width="100"  align="center">N° de INF. y fecha de elaboración (ORAA)</td>
        //                     <td width="45"  align="center">Tipo</td>
        //                 </tr>
        //             </thead>';
        //         $tabla.='<tr>
        //             <td width="24"  align="center">'.($key+1).'</td>
        //             <td width="76"  align="center">'.$value->CodigoCarrera.'</td>
        //             <td width="200"  align="center">'.$value->Paterno.' '.$value->Materno.' '.$value->Nombres.'</td>
        //             <td width="95"  align="center">'.$value->FechaTramite.'</td>
        //             <td width="100"  align="center">'.$value->Elaboracion.'</td>
        //             <td width="45"  align="center">'.($value->Tipo==""?'Fisico':'Digital').'</td>
        //         </tr> ';
        //     }
        //     $carrera = $value->CodCar;
        //     $tipo = $value->IdTipoTramite;



        // }
        // $tabla.='</table>';
        // $pdf::writeHTML($tabla, true, false, true, false, 'C');
        // $pdf::ln();
        // $pdf::SetFont('helvetica', 'b', 12);
        // $pdf::Cell(0, 5, 'INGENIERIA GEOLOGIA', 0, 1, 'C', 0, '', 0);
        // $pdf::ln();
        // $pdf::SetFont('helvetica', 'b', 10);
        // $pdf::Cell(0, 5, 'GRADO BACHILLER AUTOMATICO', 0, 1, 'L', 0, '', 0);
        // $pdf::ln();

        // $pdf::SetFont('helvetica', '', 9);
        // $tabla = '
        // <table cellspacing="0" cellpadding="2" border="1">
        //     <thead>
        //         <tr style="font-weight: bold;">
        //             <td width="24"  align="center">N°</td>
        //             <td width="70"  align="center">Tipo de Trámite</td>
        //             <td width="70"  align="center">Escuela Profesional</td>
        //             <td width="46"  align="center">Cod. Matrícula</td>
        //             <td width="70"  align="center">Apellido Paterno</td>
        //             <td width="70"  align="center">Apellido Materno</td>
        //             <td width="70"  align="center">Nombres</td>
        //             <td width="50"  align="center">Fecha de Ingreso del Trámite</td>
        //             <td width="70"  align="center">N° de INF. y fecha de elaboración (ORAA)</td>
        //         </tr>
        //     </thead>';

        // foreach($datos as $key => $value){
        //     $tabla.='<tr>
        //                 <td width="24"  align="center">'.($key+1).'</td>
        //                 <td width="70"  align="center">'.$value->TipoTramite.'</td>
        //                 <td width="70"  align="center">'.$value->EscuelaProfesional.'</td>
        //                 <td width="46"  align="center">'.$value->CodigoCarrera.'</td>
        //                 <td width="70"  align="center">'.$value->Paterno.'</td>
        //                 <td width="70"  align="center">'.$value->Materno.'</td>
        //                 <td width="70"  align="center">'.$value->Nombres.'</td>
        //                 <td width="50"  align="center">'.$value->FechaTramite.'</td>
        //                 <td width="70"  align="center">'.$value->Elaboracion.'</td>
        //             </tr> ';
        // }


        // $tabla.='</table>';
        // $pdf::writeHTML($tabla, true, false, true, false, 'C');
        // $pdf::ln();
        // date_default_timezone_set('America/Lima');
        $pdf::SetFont('helvetica', 'b', 11);

        $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        $fecha = "Puno, ".date("d")." de ".$meses[date('n')-1]." del ".date("Y").".";
        $pdf::Cell(0, 7, $fecha, 0, 1, 'R', 0, '', 0);


        $pdf::Output('Lista.pdf', 'I');
        return false;
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
